.TH pol2des 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
pol2des - polynomial matrix to descriptor form
.SH CALLING SEQUENCE
.nf
[N,B,C]=pol2des(Ds)
.fi
.SH PARAMETERS
.TP 12
Ds
: polynomial matrix
.TP
N, B, C 
: three real matrices
.SH DESCRIPTION
Given the polynomial matrix \fVDs=D_0 +D_1 s +D_2 s^2 +... +D_k s^k\fR,
\fVpol2des\fR returns three  matrices \fVN, B, C\fR, with \fVN\fR nilpotent 
such that:
.LP
\fVDs = C (sN-eye)^-1 B \fR
.SH EXAMPLE
.nf
s=poly(0,'s');
G=[1,s;1+s^2,3*s^3];[N,B,C]=pol2des(G);
G1=clean(C*inv(s*N-eye)*B),G2=numer(G1)
.fi
.SH SEE ALSO
ss2des, tf2des
.SH AUTHOR
F.D.

