.TH binary 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
binary - binary file management
.SH CALLING SEQUENCE
.nf
[fd,err]=mopen('file-name' [, mode,  swap ])
[err]=mclose([fd])
[x]=mget([n,type,fd])       // default values n=1,type='l',fd=-1
[err]=mput(x [,type,fd])    // default values type='l',fd=-1
str=mgetstr([n,fd])         // default values n=1, fd=-1
[err]=mputstr(str [, fd]);  // default value  fd = -1 
[err]=meof([fd])	    // default value  fd = -1 
mseek(n [,fd, flag])	    // default values fd = -1, flag = 'set'
mtell([fd])		    // default value  fd = -1
.fi
.SH PARAMETERS
.TP 10
mode,type 
: strings.
.TP 10
n,err,fd
: scalar 
.TP 10
x
: vector
.SH DESCRIPTION
A set of function to read and write binary files.
.LP
The \fVtype\fR parameter can be one of the following :
.TP 13
"l","s","ul","us","d","f","c","uc"
: for reading or writing respectively a long, a short, an unsigned long, an unsigned 
short, a double, a float, a char and an unsigned char. The bytes which are 
read are automatically swapped if necessary (by checking little-endian status ) in 
order to produce machine independent binary files. 
.LP 
The automatic swap of bytes can be cancelled by adding a third ( with value zero ) argument to the \fVmopen\fR
function  ( \fVmopen(file,"wb",0)\fR).
.TP
"ull","uls","ubl","ubs"
: for reading or writing respectively unsigned little-endian long or
short and unsigned big-endian long or short. 
.LP
The \fVfd\fR parameter returned by the function \fVmopen\fR is used as
a file descriptor (it's a positive integer). When specifying the
\fVfd\fR parameter, the value \fV-1\fR refers to the default file 
( i.e the last opened file).
.LP
The \fVmode\fR parameter can be \fV"rb"\fR for read binary or \fV"wb"\fR for write 
binary.
.LP
The function \fVfseek()\fR sets the position of the next input or output operation
on  the stream \fVfd\fR. The new position is at
the signed distance given by \fVn\fR bytes from  the  beginning,  from
the current position, or from the end of the file, according  to the 
\fVflag\fR value which can be \fV'set'\fR, \fV'cur'\fR or \fV'end'\fR.
.LP
The function \fVftell()\fR returns the offset of the current byte  relative  to
the beginning of the file associated with the named stream \fVfd\fR.
.SH EXAMPLE 
.nf 
filen = 'test.bin'
mopen(filen,'wb');
mput(1996,'ull');mput(1996,'uls');mput(1996,'ubl');mput(1996,'ubs');
mput(1996,'l');mput(1996,'s');mput(98,'uc');mput(98,'c');
mput(1996,'d');mput(1996,'f');mput(1996,'ul');mput(1996,'us');
mclose();

mopen(filen,'rb')
if 1996<>mget(1,'ull') ;write(%io(2),'Bug');end;
if 1996<>mget(1,'uls') ;write(%io(2),'Bug');end;
if 1996<>mget(1,'ubl') ;write(%io(2),'Bug');end;
if 1996<>mget(1,'ubs') ;write(%io(2),'Bug');end;
if 1996<>mget(1,'l') ;write(%io(2),'BUG');end;
if 1996<>mget(1,'s') ;write(%io(2),'Bug');end;
if 98<>mget(1,'uc') ;write(%io(2),'Bug');end;
if 98<>mget(1,'c') ;write(%io(2),'Bug');end;
// with eventuel swap 
if 1996<>mget(1,'d') ;write(%io(2),'Bug');end;
if 1996<>mget(1,'f') ;write(%io(2),'Bug');end;
if 1996<>mget(1,'ul') ;write(%io(2),'Bug');end;
if 1996<>mget(1,'us') ;write(%io(2),'Bug');end;
mclose();

// an example with two files 

file1 = 'test1.bin';
file2 = 'test2.bin';
fd1=mopen(file1,'wb');
fd2=mopen(file2,'wb');
mput(1996,'ull',fd1);
mput(1996,'ull',fd2);
mclose(fd1);
mclose(fd2);

fd1=mopen(file1,'rb');
if 1996<>mget(1,'ull',fd1) ;write(%io(2),'Bug');end;
fd2=mopen(file2,'rb');
if 1996<>mget(1,'ull',fd2) ;write(%io(2),'Bug');end;
mclose(fd1);
mclose(fd2);

// and example with mseek 
file3='test3.bin'
fd1= mopen(file3,'wb');
for i=1:10, mput(i,'d'); end 
mseek(0);
mput(678,'d');
mseek(0,fd1,'end');
mput(932,'d');
mclose(fd1)
fd1= mopen(file3,'rb');
res=mget(11,'d')
res1=[1:11]; res1(1)=678;res1($)=932;
if res1<>res ;write(%io(2),'Bug');end;
mclose(fd1);
.fi 

