.TH convol 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
convol - convolution
.SH CALLING SEQUENCE
.nf
[y]=convol(h,x)
[y,e1]=convol(h,x,e0)
.fi
.SH PARAMETERS
.TP 10
x,h
:input sequences (\fVh\fR is a "short" sequence, \fVx\fR a "long" one)
.TP
e0
: old tail to overlap add (not used in first call)
.TP
y
: output of convolution
.TP
e1
: new tail to overlap add (not used in last call)
.SH DESCRIPTION
calculates the convolution \fVy= h*x\fR of two
discrete sequences by using the fft.  Overlap add method can be used.
.LP
USE OF OVERLAP ADD METHOD: 
For x=[x1,x2,...,xNm1,xN]
First call is [y1,e1]=convol(h,x1); 
Subsequent calls : [yk,ek]=convol(h,xk,ekm1);
Final call : [yN]=convol(h,xN,eNm1);
Finally y=[y1,y2,...,yNm1,yN]
.SH EXAMPLE
.nf
x=1:3;
h1=[1,0,0,0,0];h2=[0,1,0,0,0];h3=[0,0,1,0,0];
x1=convol(h1,x),x2=convol(h2,x),x3=convol(h3,x),
convol(h1+h2+h3,x)
p1=poly(x,'x','coeff')
p2=poly(h1+h2+h3,'x','coeff')
p1*p2
.fi
.SH SEE ALSO
corr, fft, pspect
.SH AUTHOR
F. D , C. Bunks Date 3 Oct. 1988


