/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.1/rpc/sources/RCS/kr_ui_rpc_main.h,v $
  SHORTNAME      : kr_ui_rpc_main.h
  SNNS VERSION   : 4.1

  PURPOSE        : 
  NOTES          :

  AUTHOR         : Sven Doering
  DATE           : 

  CHANGED BY     : 
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 1.5 $
  LAST CHANGE    : $Date: 1995/11/16 07:26:21 $

             (c) 1994 by Sven Doering and the SNNS-Group

******************************************************************************/

#ifndef _UI_RPC_MAIN_DEFINED_
#define _UI_RPC_MAIN_DEFINED_

extern void QuitKernel(int Mode);
/* Quit Modes */
#define NOSAVE  0
#define SAVENET 1


/* Errors */
#define NOERROR 0
#define TOMANYKERNELS -1

# define MAXKERNELS 9 /* MAX 99 */

/* How long stay running without connection to the world 1 = 1min */
#define TIMEOUTVAL 15
extern long timervalue;
extern long acttimervalue;



struct client {
    int  xguiid;
    int  kernelid;
    char *xguihost;
    long xguiprogramm;
    long xguiversion;
    int uid;
    int pid;
    int status;
    CLIENT *cl;
    long permissions;
};

extern bool_t isModifying(int req);
extern int make_xgui_callback(struct client *Client,int error);
extern void checkForRPCCalls(void);

extern int anzClients;
extern int globalxguiid;

/* Stores the kernel configuration */
extern bool_t config_received;
extern par_config  kernel_config;
extern par_config  *kernel_config_ptr;
extern parallel_kernel m_coopKernels[MAXPARAKERNELS];
extern CLIENT *m_coopKernelsCl[MAXPARAKERNELS];
extern struct timeval m_coopKernelsStartT[MAXPARAKERNELS];
extern struct timeval m_coopKernelsLastT[MAXPARAKERNELS];
extern SVCXPRT global_trans;
extern SVCXPRT *global_transp;
extern int m_anzCoopKernels;
extern int kernelMode;
extern long rpcversion ;
extern bool_t patternloaded;

#define MAXCLIENTS 10
extern struct client xguiclient;


#endif

