'\"macro stdmacro
.nr X
.TH QuickPage 1 "21 June 1997" "Thomas Dwyer III"
.\" Copyright (c) 1995-1997 Thomas Dwyer III
.SH NAME
QuickPage \- SNPP client/server for sending messages to an alpha-numeric pager
.SH SYNOPSIS
.B qpage
[
.B \-dhimQv
] [
.BI \-a " [+][dd+]hhmm
|
.BI \-a " YYMMDDHHMMSS
] [
.BI \-c " coverage
] [
.BI \-C " config
] [
.BI \-f " from
] [
.BI \-l " level
] [
.BI \-p " pagerid
] [
.BI \-P " pagerid
] [
.BI \-s " server
] [
.I message
]
.LP
.B qpage
[
.B \-d
]
.BI \-q " interval
.SH DESCRIPTION
.B QuickPage
sends messages to a paging terminal using the SNPP and IXO (also known
as TAP) protocols.  It is normally used with no options other than
a recipient and the message text, in which case the message is
sent to the SNPP server where it is submitted to a page queue
to be sent by a separate daemon process.
Page groups and duty schedules are supported.
Status notification messages
indicating the success or failure of a page
are sent via e-mail to submitters of
high-priority (level 0) pages.
.LP
If no message is specified on the command line,
the user is prompted for the message text.  Characters are read from
standard input until a line containing only a period is
received.  All occurrences of whitespace
within the message text are reduced to a single space character.
.LP
Messages received by the
.B QuickPage
daemon that are longer than
the maximum page length (see below) are split into multiple segments
and sent as separate pages.
Each message segment is prefixed with its segment number.
The maximum number of segments a into which a message will be split
is configurable.
If a message exceeds this limit, the last allowed segment will be
prefixed with 't', indicating that the message is truncated;
otherwise, the last segment is prefixed with 'e' to indicate the
end of the message.
Messages that fit into a single page are not prefixed with segment numbers.
All messages are prefixed with CALLerid information (see RFC-1861), if
available.
.LP
.SH OPTIONS
The following options are supported: 
.TP
.BI \-a
Send the page at the specified time.  A time specification prefixed
with a plus sign (+) is added to the current time.  The
.B QuickPage
daemon will not send any pages with a timestamp newer than the current
time.
This feature may be used to provide a simple alarm clock function
for meeting reminders, etc.
This option applies only to the pagerid(s) specified by the next
.B \-p
option.
.TP
.BI \-c
Use a different coverage area or paging service.  This option is
only useful if the recipient has more than one pager and/or more
than one paging service. 
This option applies only to the pagerid(s) specified by the next
.B \-p
option.
.TP
.BI \-C
Specify an alternate configuration file.
.TP
.BI \-d
Debug mode.  Very verbose and probably not interesting for the
normal user.  This option is provided for debugging purposes only.
.TP
.BI \-f
Specify who the page is from.  This option specifies the argument to
the SNPP
.B CALLerid
command.  Every message segment will be
prefixed with the value specified by this option.  A null
argument (
.B \-f
"") may be specified to suppress the message prefix.
The default is the userid of the person running
.B QuickPage.
.TP
.BI \-h
Help.  Print a brief summary of the command line options.
.TP
.BI \-i
Use interactive mode.  The page is sent immediately and summary
messages are printed during the course of the transaction.
This option may only be used on a machine with a physically
attached modem.  This option is intended for debugging purposes
only.  The
.B \-d
option, when used in conjunction with this option, can be
very effective in troubleshooting problems between the SNPP
server and the remote paging terminal.
.TP
.BI \-l
Specify the service level for this page.  The service level must be
a number between 0 and 11, inclusive.
The TME protocol specifies service level as follows:
.LP
.RS
.RS
.PD 0
0 - Priority
.TP
1 - Normal (default)
.TP
2 - Five minutes
.TP
3 - Fifteen minutes
.TP
4 - One hour
.TP
5 - Four hours
.TP
6 - Twelve hours
.TP
7 - Twenty Four hours
.TP
8 - Carrier specific '1'
.TP
9 - Carrier specific '2'
.TP
10 - Carrier specific '3'
.TP
11 - Carrier specific '4'
.PD
.RE
.LP
With the exception of level zero, service levels have no
meaning to
.B QuickPage
but they are accepted for compatibility with other programs.
Pages submitted with service level zero cause e-mail to be
sent to the submitter whenever a page succeeds or fails.
Any service level specified by the user is passed on to
the SNPP server.
This option applies only to the pagerid(s) specified by the next
.B \-p
option.
.RE
.TP
.BI \-m
This option tells
.B QuickPage
to read an e-mail message from standard input.  A page is
constructed by concatenating the From: header (XXX), the
Subject: header (YYY), and lines from the message
body (ZZZ) as follows:
.LP
.RS
.RS
XXX (Subj: YYY) ZZZ ...
.RE
.LP
Minimal support is provided for multipart MIME messages.  The first
part with a Content-Type: of text/plain will be processed.  The
remaining parts will be discarded.  This will reduce the problems
associated with people accidentally mailing binaries to their pagers.
.LP
The X-sun-attachment type is not supported and should not be used.
MIME is a documented standard.
The X-sun-attachment type is neither documented nor standard.
However,
.B QuickPage
will still use the From: and Subject: lines (but no message body)
from such messages for those people who insist on using it anyway.
.LP
A line starting with two dashes (--) in the message body (or in
a MIME text part) is assumed to be the start of a signature and
will cause
.B QuickPage
to stop processing the message at that point.
.RE
.TP
.BI \-p
Specify the pagerid of the intended recipient.
Multiple recipients may be specified by separating
their pager IDs with commas, slashes, or colons
(e.g. pagerid1,pagerid2,pagerid3).
No spaces are permitted between recipients and separator characters.
Any
.B \-a,
.B \-c,
or
.B \-l
options previously encountered on the command line are reset
to their default values after this option is processed.
This option may occur multiple times on the command line, each
possibly preceded by different
.B \-a,
.B \-c,
or
.B \-l
options.
.TP
.BI \-P
Like
.B \-p
but does not reset
.B \-a,
.B \-c,
or
.B \-l
options previously encountered on the command line.
.TP
.BI \-q
Start a
.B QuickPage
daemon process.  This option causes
.B QuickPage
to detach itself from the controlling terminal and create two
processes: one to listen for incoming SNPP connections and one for
processing the page queue.  This option also specifies the number
of seconds
.B QuickPage
sleeps between queue runs.  See the NOTES section below for more
information.
.TP
.BI \-Q
Print the current contents of the page queue.  This option may
only be used on the
.B QuickPage
server.
.TP
.BI \-s
Specify the name(s) of the SNPP server(s).  The hostnames used by
a client to contact a server are
determined by checking the following in this order:
.LP
.RS
.RS
.PD 0
the
.B \-s
option
.TP
the environment variable SNPP_SERVER
.TP
the contents of the compiled in filename
.TP
the compiled in hostname
.PD
.RE
.LP
Multiple hostnames are permitted by separating them with commas or colons.
If multiple servers are used, it is assumed that they all have identical
copies of the configuration file.
.RE
.TP
.BI \-v
Print the version of
.B QuickPage
and exit.
.LP
The
.B QuickPage
server requires a configuration file.  This file is read
once for each incoming
SNPP connection and once for each queue run.  The configuration file
is made up of major and minor keyword=value pairs.
Major keywords must start at the beginning of a line.
Minor keywords must contain leading whitespace.
All keywords must be immediately followed with an equal sign (=).
Spaces are permitted between the equal sign and the value.
Keywords may appear in any order with the following three exceptions:
.RS

Minor keywords must be grouped together under their respective major keyword.

Services must be defined before any pagers that reference them.

Pagers must be defined before any groups that reference them.
.RE
.LP
The major keywords are:
.RS
.TP 15
administrator
The e-mail address of the
.B QuickPage
administrator.  If defined, e-mail
notification will be sent to the
.B QuickPage
administrator whenever a page fails (i.e. when
.B maxtries
has been exceeded).
This address is also used in the Reply-To: header for status notification
messages sent to users who submit high-priority pages. 
.TP
forcehostname
(true, false, or @mailhost)
Force the destination
address to be qualified with a hostname
when sending e-mail status notification to users.
This option can be used when the
.B QuickPage
daemon is running on a machine that does not
handle unqualified e-mail addresses correctly.
If the value of this keyword starts with the '@' character,
it will be appended as-is to unqualified e-mail addresses.
If the value of this keyword is "true" then the submitter's hostname
will be appended to such addresses.
The default is false (do not append hostnames).
.TP
identtimeout
The number of seconds to wait for a reply
before giving up on RFC-1413 queries.
An integer less than or equal to zero disables ident functionality.
The default is 10 seconds.
.TP
snpptimeout
The number of seconds to wait for an SNPP command before
terminating the connection.
The default is 60 seconds.
.TP
queuedir
The location of the page queue.
There is no default queue directory; this option must be specified
in the configuration file.
.TP
service
The start of a paging service definition.
The argument to this keyword is the name of the paging service.
If a service named
.B default
exists, the values of its minor keywords are used as defaults for
all other service definitions.
This keyword has the following minor keywords:
.RS
.TP 15
device
The name of the device the modem is physically connected
to, such as /dev/cua/a.
There is no default device; this option must be specified
in the configuration file.
.TP
dialcmd
The command, including a phone number, that the modem should use
to connect to the remote paging service.
There is no default dial command; this option must be specified
in the configuration file.
.TP
password
The password to use when logging into the remote paging service.
The IXO specification defines the password as an optional six
character alphanumeric string.
The default is an empty string ("").
.TP
baudrate
The speed to use while talking to the modem.
The default is 300 baud.
.TP
parity
The parity to use (even, odd, or none) while talking to the modem.
The default is even.
.TP
maxmsgsize
The maximum number of characters allowed in a single
page segment.
The default is 80 characters.
.TP
maxpages
The maximum number of page segments to send when a message exceeds
.B maxmsgsize.
The value of this option must be between 1 and 9, inclusive.
The default is 9 page segments.
.TP
maxtries
The number of times to attempt sending a page before giving up.
If the modem is busy (i.e. tip or cu is currently using it) or if
the modem returns BUSY in response to the dial command, the counter
is not incremented.  Thus a busy modem will cause
.B QuickPage
to retry the page forever.
The default is 6.
.TP
identfrom
(true or false)
This keyword specifies whether to use the ident response as the
message prefix if no CALLerid SNPP command is received.
The default is true.
.TP
allowpid
(true or false)
This keyword specifies whether the
.B QuickPage
daemon will accept numeric pagerids for pagers not specified in
the configuration file.  The default service is
used for such pagerids unless the user explicitly chooses a
different service.
The default for this keyword is false.
.RE
.TP
pager
The start of a pager definition.
The argument to this keyword is the username associated with the pager.
This username will be specified by the
.B \-p
option on the command line when running
.B QuickPage
in client mode.
This keyword has the following minor keywords:
.RS
.TP 15
pagerid
The pagerid sent to the remote paging service for this pager.
.TP
service
The default service to use for this pager.
.RE
.TP
group
The start of a group definition.  The argument to this keyword is
the name of a new page group.  This keyword has the following minor
keyword:
.RS
.TP 15
member
A member of this group.  The member must have a valid
.B pager
entry before this group definition.  An optional duty schedule (see below)
may be specified.
This keyword may appear multiple times within a single group.
.RE
.RE
.LP
The default service, if present, must specify values for the
.B device
and
.B dialcmd
keywords.  If there is no default service, all services
must specify these values.
.LP
Member definitions within a page group have the syntax:
.RS

member=name[/DayStart-End]

.RE
Where the square brackets indicate an optional duty schedule.
The duty schedule has the same syntax as the
.B Time
parameter in the UUCP
.B Systems
file:
.B Day
is a list of case-sensitive weekday abbreviations (e.g. MoTuTh),
.B Start
is the start time (e.g. 800), and
.B End
is the end time (e.g. 1700).
The word
.B Any
is synonymous with
.B SuMoTuWeThFrSa.
Midnight may be represented as either 0 or 2400.
The time range must not span across midnight.
A slash is required to separate the duty schedule from the member name.
Multiple member definitions for the same person with different duty
schedules are permitted (see the example below).
Overlapping duty schedules for the same person within a group will
not cause duplicate pages to be sent to that person.
See the following example configuration file:
.RS

#
.br
# QuickPage configuration file
.br
#
.br
identtimeout=10
.br
queuedir=/var/spool/qpage

service=default
.RS
device=/dev/cua/b
.br
dialcmd=ATDT482-1111
.br
baudrate=1200
.br
allowpid=yes
.br
maxtries=6
.RE

# use the S7 modem register to set a connection timeout
.br
service=supercom
.RS
dialcmd=ATS7=30DT482-9649
.br
maxmsgsize=80
.br
maxpages=9
.RE

pager=tomiii
.RS
pagerid=710
.br
service=supercom
.RE

pager=tony
.RS
pagerid=711
.br
service=supercom
.RE

group=sysadmin
.RS
member=tomiii/MoWeFr800-1700
.br
member=tony/TuTh800-1700
.br
member=tony/SaSu900-1600
.RE
.RE
.SH NOTES
The order of the command line options is important.  The
.B \-a,
.B \-c,
and
.B \-l
options must precede the pagerids they refer to.
.LP
The
.B \-p
option resets
.B \-a,
.B \-c,
and
.B \-l
to their default values.  If this behavior is not desired, use
.B \-P
instead.
.LP
The
.B QuickPage
daemon runs as two separate processes.
The child processes
the pages in the
page queue.  If any pages remain in the queue at the end of
a run (if the remote modem was busy, for example, or if a page
is being held until a future time), the child sleeps for the
time specified by the
.B \-q
option and tries again.  Otherwise the child goes to sleep until
awakened by the parent.
.LP
The parent daemon process listens for
incoming SNPP connections and forks an additional child process to
handle each request.  After a page is accepted, SIGUSR1 is sent
to the sleeping child process causing it to start a queue run.
.LP
If the CALLerid information received by the
.B QuickPage
daemon contains the '@' character, it is truncated at that character
before being prepended to messages.  However, it is used as-is for
the destination address when sending e-mail notification for
high-priority recipients.
.LP
Due to limitations of SNPP,
.B QuickPage
has to derive e-mail notification addresses from the
.B CALLerid
information.
Since the
.B CALLerid
information might be bogus, all e-mail notifications
are sent using a null reverse path.
This will prevent error messages from being generated by the
mail system if a bogus address is used for e-mail notification.
.LP
If the server does not receive a
.B CALLerid
command (i.e. the
.B \-f
flag contains a null argument),
notification messages will not be sent, regardless of the
specified service level.
.LP
When the
.B \-m
flag is used to send a high-priority page,
the status notification is sent
to the return address in the original e-mail message
unless overridden by the
.B \-f
option.
.LP
The length of SNPP commands is limited only by the amount of memory
available to
.B QuickPage.
.LP
.B QuickPage
uses a timeout of 255 seconds while waiting for a connection from the
remote modem.  This allows the administrator to specify an
appropriate timeout
by setting the modem's S7 register in the dial command.
.LP
The modem must control the CD (carrier-detect) line;
otherwise, the on/off hook status of the modem cannot be determined.
This is especially important
if more than one paging service (phone number) is used since
.B QuickPage
must know when it's safe to send dial commands to the modem.
.LP
.SH FILES
/etc/qpage.cf
.SH SEE ALSO
.B RFC-1861
.SH KNOWN BUGS
.B QuickPage
cannot send a single e-mail message to multiple addresses.
If such functionality is desired, a mailing list should be created
for this purpose.
.LP
Pages are not queued on the client side.  As a result, if no
servers are available to the client at the time a page is submitted,
an error message is printed and the page is discarded.
.LP
Please send bug reports to tomiii@mtu.edu.
.SH AUTHOR
.B QuickPage
was written by Thomas Dwyer III <tomiii@mtu.edu> and is provided
to the internet community free of charge.
.LP
Copyright (c) 1995-1997 Thomas Dwyer III
