/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/*   (c) 1995-1998.  The Regents of the University of California.  All     */
/*   rights reserved.                                                      */
/*                                                                         */
/*   This work was produced at the University of California, Lawrence      */
/*   Livermore National Laboratory (UC LLNL) under contract no.            */
/*   W-7405-ENG-48 (Contract 48) between the U.S. Department of Energy     */
/*   (DOE) and The Regents of the University of California (University)    */
/*   for the operation of UC LLNL.  Copyright is reserved to the           */
/*   University for purposes of controlled dissemination,                  */
/*   commercialization through formal licensing, or other disposition      */
/*   under terms of Contract 48; DOE policies, regulations and orders;     */
/*   and U.S. statutes.  The rights of the Federal Government are          */
/*   reserved under Contract 48 subject to the restrictions agreed upon    */
/*   by the DOE and University.                                            */
/*                                                                         */
/*                                                                         */
/*                              DISCLAIMER                                 */
/*                                                                         */
/*   This software was prepared as an account of work sponsored by an      */
/*   agency of the United States Government.  Neither the United States    */
/*   Government nor the University of California nor any of their          */
/*   employees, makes any warranty, express or implied, or assumes any     */
/*   liability or responsibility for the accuracy, completeness, or        */
/*   usefulness of any information, apparatus, product, or process         */
/*   disclosed, or represents that its specific commercial products,       */
/*   process, or service by trade name, trademark, manufacturer, or        */
/*   otherwise, does not necessarily constitute or imply its               */
/*   endorsement, recommendation, or favoring by the United States         */
/*   Government or the University of California. The views and opinions    */
/*   of the authors expressed herein do not necessarily state or reflect   */
/*   those of the United States Government or the University of            */
/*   California, and shall not be used for advertising or product          */
/*   endorsement purposes.                                                 */
/*                                                                         */
/*   Permission to use, copy, modify and distribute this software and its  */
/*   documentation for any non-commercial purpose, without fee, is         */
/*   hereby granted, provided that the above copyright notice and this     */
/*   permission notice appear in all copies of the software and            */
/*   supporting documentation, and that all UC LLNL identification in      */
/*   the user interface remain unchanged.  The title to copyright LLNL     */
/*   XDIR shall at all times remain with The Regents of the University     */
/*   of California and users agree to preserve same. Users seeking the     */
/*   right to make derivative works with LLNL XDIR for commercial          */
/*   purposes may obtain a license from the Lawrence Livermore National    */
/*   Laboratory's Technology Transfer Office, P.O. Box 808, L-795,         */
/*   Livermore, CA 94550.                                                  */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/

#include <Xm/Xm.h>
#include <sys/param.h>
#include "xdir.h"

extern int safe_to_redraw;
extern Display *display;


/*
 * cb_resize_dirwin - Callback for rearranging the entries in the
 *                    directory table to better fit the new size of the
 *                    drawing area widget (and scrolled window widget).
 */
void
cb_resize_dirwin(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	if (!XtIsRealized(dirwin->w_drawingArea))
		fatal_error("Bug in cb_resize_dirwin()");

	/* Make sure that the data structures are consistent */
	if (!safe_to_redraw)
		return;

	calc_dirwin_geometry(dirwin);
	reset_scrollbars(dirwin, -1, -1);

	XClearArea(display, XtWindow(dirwin->w_drawingArea), 0, 0, 0, 0, True);
}


/*
 * calc_dirwin_geometry - Determine the layout of entries in the drawing
 *                        area.  Must be called before entries are drawn.
 */
calc_dirwin_geometry(dirwin)
struct dirwin_st *dirwin;
{
	int entry_width;
	int ncols;
	int nrows;
	int nrows_visible;
	Dimension drawing_area_width;
	Dimension drawing_area_height;
	Widget w_vertical_sb;
	Widget w_horizontal_sb;

	/* Unmanage scrollbars */
	XtVaGetValues(dirwin->w_scrolledWindow,
		XmNhorizontalScrollBar,	&w_horizontal_sb,
		XmNverticalScrollBar,	&w_vertical_sb,
		NULL
	);

	/* Easy if directory is empty */
	if (dirwin->nentries == 0) {
		dirwin->ncols = 0;
		dirwin->nrows = 0;
		dirwin->virtual_width = 2*HMARGIN;
		XtVaGetValues(dirwin->w_drawingArea, XmNheight,	&drawing_area_height,
			NULL);
		dirwin->nrows_visible =
			((int)drawing_area_height-VTMARGIN-VBMARGIN+VSPACING)
			/(dirwin->entry_height+VSPACING);
		return;
	}

	switch (dirwin->layout) {
	case TABULAR:
	case ICONIC:
		entry_width = dirwin->max_entry_width;
		while (1) {
			XtVaGetValues(dirwin->w_drawingArea,
				XmNwidth,	&drawing_area_width,
				XmNheight,	&drawing_area_height,
				NULL
			);
			if (!XtIsManaged(w_horizontal_sb) &&
					entry_width+2*HMARGIN > (int)drawing_area_width) {
				XtManageChild(w_horizontal_sb);
				continue;
			}
			ncols = ((int)drawing_area_width-2*HMARGIN+HSPACING)
				/(entry_width+HSPACING);
			if (ncols == 0)
				ncols = 1;
			nrows = (dirwin->nentries+ncols-1)/ncols;
			nrows_visible =
				((int)drawing_area_height-VTMARGIN-VBMARGIN+VSPACING)
				/(dirwin->entry_height+VSPACING);
			if (!XtIsManaged(w_vertical_sb) && nrows > nrows_visible) {
				XtManageChild(w_vertical_sb);
				continue;
			}
			break;
		}
		dirwin->virtual_width = 2*HMARGIN+ncols*(entry_width+HSPACING)
			-HSPACING;
		break;
	case TREE:
	case FULL_INFO:
		if (dirwin->layout == TREE)
			entry_width = CWIDTH+CMARGIN+tree_width(dirwin);
		else
			entry_width = dirwin->max_entry_width;
		nrows = dirwin->nentries;
		ncols = 1;
		while (1) {
			XtVaGetValues(dirwin->w_drawingArea,
				XmNwidth,	&drawing_area_width,
				XmNheight,	&drawing_area_height,
				NULL
			);
			if (!XtIsManaged(w_horizontal_sb) &&
					entry_width+2*HMARGIN > (int)drawing_area_width) {
				XtManageChild(w_horizontal_sb);
				continue;
			}
			nrows_visible =
				((int)drawing_area_height-VTMARGIN-VBMARGIN+VSPACING)
				/(dirwin->entry_height+VSPACING);
			if (!XtIsManaged(w_vertical_sb) && nrows > nrows_visible) {
				XtManageChild(w_vertical_sb);
				continue;
			}
			break;
		}
		dirwin->virtual_width = 2*HMARGIN+entry_width;
	}
	dirwin->ncols = ncols;
	dirwin->nrows = nrows;
	dirwin->nrows_visible = nrows_visible;
}


/*
 * tree_width - Calculate the widest viewable entry in the directory
 *              display (taking indentation into account).
 *
*/
tree_width(dirwin)
struct dirwin_st *dirwin;
{
    int i;
    int w;
    int width = 0;

    for (i=0; i<dirwin->nentries; i++) {
        w = INDENT*dirwin->entries[i].level+dirwin->entries[i].width;
        width = MAX(width, w);
    }
   
    return width;
}

