//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef CARTRIDGE_HXX
#define CARTRIDGE_HXX

class Cartridge;
class Properties;
class System;

#include "machine.hxx"
#include "Device.hxx"

/**
  A cartridge is a device that connects to the system.  It contains
  the code from a 2600 game cartridge and handles any bank switching
  performed by the cartridge. 

  @author  Bradford W. Mott
  @version $Id: Cart.hxx,v 1.2 1997/05/17 19:00:02 bwmott Exp $
*/
class Cartridge : public Device
{
  public:
    /// Class method which makes sure the ROM image file exists
    static void exists(const Properties& properties);

    /// Class method that creates a new cartridge
    static Cartridge* create(System& system, const Properties& properties);

  public:
    /// Constructor
    Cartridge(System& system);
 
    /// Destructor
    virtual ~Cartridge();

  public: 
    /// Answer the byte at the given address
    virtual uByte peek(uWord addr) = 0;

    /// Store value in the given address
    virtual void poke(uWord addr, uByte value);

    /// Reset to my power on state
    virtual void reset() = 0;
};
#endif

