/********************************************************************************
 * Copyright (c) Razvan Surdulescu 1996
 *               Erik Kunze        1996 - 1998
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Razvan Surdulescu
 *         Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef _XZX_DIALOG_H
#define _XZX_DIALOG_H
/* $Id: dialog.h,v 4.1 1998/01/06 21:21:30 erik Rel $ */
#include <X11/Xlib.h>
#include "config.h"
#include "screen.h"

#define MENU_TEXT_ATTR		(         (WHITE << 3) | BLACK)
#define MENU_SELECT_ATTR	(BRIGHT | (WHITE << 3) | BLACK)
#define MENU_DISABLED_ATTR	(BRIGHT | (WHITE << 3) | BLUE )
#define MENU_CURSOR_X		0
#define MENU_CURSOR_Y		1
#define NOPTS(x)			(sizeof(x) / sizeof(x[0]) - 2)

extern void DialogInit(int);
extern void SetAttr(uns8);
extern uns8 GetAttr(void);
extern void SetCursor(uns8, uns8);
extern void GetCursor(uns8 *, uns8 *);
extern void ClearScreen(void);
extern void DrawBox(uns8, uns8);
extern void PrintLetter(uns8);
extern void PrintString(char *);
extern KeySym GetKey(void);
extern int GetString(char *, int, int);
extern int ConfirmBox(char *);
extern int  EnterOSD(void);
extern void LeaveOSD(int);
extern void SaveScreen(void);
extern void RestoreScreen(void);
extern char *FileSelector(char *, int, char *, char *, char *);
extern void DisplayMenu(char **);
extern KeySym BrowseList(int *, int, int, void (*)(int));
extern int InDialog;
extern KeySym KeyDialog;
extern int OldSp;
extern int OldAy;
#endif

