#include "cs.h"			/* Flanger by Maldonado, with coding
				   enhancements by JPff -- July 1998 */
#include <math.h>
#include "flanger.h"

void flanger_set (FLANGER *p)
{
	/*---------------- delay  -----------------------*/
    p->maxdelay = (unsigned long)(*p->maxd  * esr);
    auxalloc(p->maxdelay * sizeof(float), &p->aux);
    p->left = 0;
    p->yt1 = 0.0f;
    p->fmaxd = (float) p->maxdelay;
}

void flanger(FLANGER *p)
{
	/*---------------- delay -----------------------*/
    unsigned long  indx = p->left;
    float *out = p->ar;  /* assign object data to local variables   */
    float *in = p->asig;
    float maxdelay = p->fmaxd, maxdelayM1 = maxdelay-1;
    float *buf = (float *)p->aux.auxp;
    float *freq_del = p->xdel; 
    float feedback =  *p->kfeedback;
    float fv1;
    long  v2;
    long  v1;
    float *yt1= &(p->yt1);

    int	nsmps = ksmps;
   
    do {
		/*---------------- delay -----------------------*/
      buf[indx] = *in++ + (*yt1 * feedback); 
      fv1 = indx - (*freq_del++ * esr); /* Make sure inside the buffer     */
      while (fv1 < 0)    fv1 += maxdelay;
      v1 = (long)fv1;
      v2 = (fv1 < maxdelayM1)? v1+1 : 0; /*Find next sample for interpolation*/
      *out++ = *yt1 = buf[v1] + (fv1 - v1) * ( buf[v2] - buf[v1]);
      if (++indx == maxdelay) indx = 0;        /* Advance current pointer */
    } while (--nsmps);
    p->left = indx;
}


