	/*	Envelope follower by Paris Smaragdis	*/
	/*	Berklee College of Music Csound development team */
	/*	Copyright (c) August 1994.  All rights reserve */

#include "cs.h"
#include <math.h>
#include "follow.h"

void flwset(FOL *p)
{
    p->wgh = p->max = p->min = 0.0f;
    p->count = 0L;
    *p->len *= esr;
    if (*p->len==0) {           /* RWD's suggestion */
      initerror("\nError: follow - zero length!\n");
      *p->len = esr;
    }
    p->count = 0;
}

void follow(FOL *p)
{
    long	n = ksmps, len = ( long)*p->len;
    float	*in = p->in, *out = p->out;

    do {
	if (*++in > p->max) p->max = *in;	/* was *in++ */
	if (*  in < p->min) p->min = *in;	/* was > */
	p->count++;
	p->count %= len;

	if (p->count == 0)	{
	    p->wgh = (p->max - p->min) * 0.5f;
	    p->max = p->min = 0.0f;
	}
		
	*out++ = p->wgh;

    } while (--n);
}
