/* pluck.h -- plucked string class declarations */

/*
 * Code conversion from C++ to C (October 1994)
 * Author: Michael A. Casey MIT Media Labs
 * Language: C
 * Copyright (c) 1994 MIT Media Lab, All Rights Reserved
 */


#ifndef _pluck_h
#define _pluck_h

#include "wavegde.h"

/* pluck -- derived class to implement simple plucked string algorithm */
typedef struct {
  OPDS h;
  float *out; /* plucked string output */
  float *freq,*amp,*pickupPos,*pickPos,*Aw0,*AwPI,*afdbk; /* inputs */

  waveguide wg;     /* general waveguide model structure   */
  filter bridge;    /* lowpass bridge filter               */
  len_t pickSamp;   /* where to pluck the string           */
  len_t pickupSamp; /* where to record string displacement */

  /* Auxillary memory allocation */
  AUXCH upperData;    /* upper rail data space */
  AUXCH lowerData;    /* lower rail data space */
  AUXCH bridgeCoeffs; /* Bridge filter coefficients */
  AUXCH bridgeData;   /* Bridge filter lattice data */
}WGPLUCK;

/* Plucked string class member functions */
/*void pluckPluck(WGPLUCK*);       /* constructor */
/*void pluckGetSamps(WGPLUCK*);    /* sample generation function */

void pluckExcite(WGPLUCK*);                      /* excitation function  */
sampPtr pluckStop(WGPLUCK*,len_t,paramT,paramT); /*damping sample generation*/
sampPtr pluckShape(WGPLUCK*,paramT);             /* pluck shape function */
sampPtr pluckFlip(WGPLUCK*,sampPtr);             /* flip the shape */
void pluckSetFilters(WGPLUCK*,paramT,paramT);    /* sets filters*/

#endif


