 ###########################################################################
 ##                                                                       ##
 ##                Centre for Speech Technology Research                  ##
 ##                     University of Edinburgh, UK                       ##
 ##                         Copyright (c) 1996                            ##
 ##                        All Rights Reserved.                           ##
 ##                                                                       ##
 ##  Permission to use, copy, modify, distribute this software and its    ##
 ##  documentation for research, educational and individual use only, is  ##
 ##  hereby granted without fee, subject to the following conditions:     ##
 ##   1. The code must retain the above copyright notice, this list of    ##
 ##      conditions and the following disclaimer.                         ##
 ##   2. Any modifications must be clearly marked as such.                ##
 ##   3. Original authors' names are not deleted.                         ##
 ##  This software may not be used for commercial purposes without        ##
 ##  specific prior written permission from the authors.                  ##
 ##                                                                       ##
 ##  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        ##
 ##  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      ##
 ##  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   ##
 ##  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     ##
 ##  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    ##
 ##  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   ##
 ##  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          ##
 ##  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       ##
 ##  THIS SOFTWARE.                                                       ##
 ##                                                                       ##
 ###########################################################################
 ##                                                                       ##
 ##                 Author: Richard Caley (rjc@cstr.ed.ac.uk)             ##
 ##                   Date: Wed Oct  1 1997                               ##
 ## --------------------------------------------------------------------  ##
 ## Main make targets.                                                    ##
 ##                                                                       ##
 ###########################################################################

###########################################################################
## utility targets

nothing:
	@$(DO_NOTHING)

FORCE:

###########################################################################
## Main make rule for building

.sub_directories: $(SUBDIRECTORIES)

${SUBDIRECTORIES} dummy_dir_name: FORCE
	@if [ ! -f $@/Makefile ] ;\
		then \
		echo "Makeing new directory $(DIRNAME)/$@" ;\
		mkdir $@ ;\
		$(subst XXX,$@,$(MAKE_RCSED_DIR)) ;\
		$(MAKE) MADE_FROM_ABOVE=1 --no-print-directory -C $@ update ; \
	fi
	@ echo "Making in directory $(DIRNAME)/$@ ..."
	@ ${MAKE}  --no-print-directory -C $@ MADE_FROM_ABOVE=yes

###########################################################################
## Clean up junk

clean:
	@echo "clean in $(DIRNAME)"
	$(RM) -fr $(OBJS) $(JAVA_CLASSES_CLASS) $(ALL_EXECS) $(ALL_EXECS:%=%.mak) $(ALL_LIBS) $(LOCAL_CLEAN) .buildlib* *~
ifdef ALL_DIRS
	@ for i in $(ALL_DIRS) ; \
	do \
	   $(MAKE) --no-print-directory -C $$i clean ; \
	done
endif

###########################################################################
## strip executables

strip: FORCE
	@echo "strip in $(DIRNAME)"
ifdef ALL_EXECS
	@ for i in $(ALL_EXECS) ; \
	do  \
	   $(STRIP) $$i ; \
	done
else
	@ echo > /dev/null
endif
ifdef ALL_DIRS
	@ for i in $(ALL_DIRS) ; \
	do \
	   $(MAKE) --no-print-directory -C $$i strip ; \
	done
endif

###########################################################################
## Force remake of dependencies

depend: FORCE
	@echo "depend in $(DIRNAME)"
	@ $(RM) -f $(DEPEND)
	@ # a little hack to get it to remake make.depend
	@ $(MAKE)  --no-print-directory nothing
ifdef ALL_DIRS
	@ for i in $(ALL_DIRS) ; \
	do \
	   $(MAKE) --no-print-directory -C $$i depend ; \
	done
endif

###########################################################################
## make a list of all files

file-list : FORCE
	@echo "file-list in $(DIRNAME)"
ifndef MADE_FROM_ABOVE
	@$(RM) -f FileList
endif
ifdef FILES
	@for i in $(FILES) ; \
	do  \
	   echo $(DIRNAME)/$$i ; \
	done >>$(TOP)/FileList 
endif
ifdef ALL_DIRS
	@for i in $(ALL_DIRS) ; \
	do \
	   $(MAKE) --no-print-directory -C $$i file-list ; \
	done
endif

###########################################################################
## list things which doc++ should process

doc++files : FORCE
	@echo "doc++files in $(DIRNAME)"
ifdef H
	@for i in $(H) ; \
	do  \
	   echo $(DIRNAME)/$$i ; \
	done >>$(TOP)/Doc++Files
endif
ifdef DOCXX
	@for i in $(DOCXX) ; \
	do  \
	   echo $(DIRNAME)/$$i ; \
	done >>$(TOP)/Doc++Files
endif
ifdef MODULES
	@for i in $(MODULES) ; \
	do  \
	   $(MODULE_TO_DOCXX) $$i.cc > $$i.doc++ ; \
	   echo $(DIRNAME)/$$i.doc++ >>$(TOP)/Doc++Files; \
	done 
endif
ifdef ALL_DIRS
	@for i in $(ALL_DIRS) ; \
	do \
	   $(MAKE) MADE_FROM_ABOVE=1 --no-print-directory -C $$i doc++files ; \
	done
endif

###########################################################################
## User Visable doc

doc++ : FORCE
	@echo "remove $(TOP)/Doc++Files"
	@$(RM) -f $(TOP)/Doc++Files
	@for d in $(DOCXX_DIRS) ; do \
		$(MAKE) -C $$d --no-print-directory doc++files ;\
	done
	@$(MAKE) -C $(TOP)/doc --no-print-directory DOCXX_ARGS='$(DOCXX_FLAGS) -d doc++' doc++process

###########################################################################
## all docs

doc++all : FORCE
	@echo "remove $(TOP)/Doc++Files"
	@$(RM) -f $(TOP)/Doc++Files
	@$(MAKE) -C $(TOP) --no-print-directory doc++files
	@$(MAKE) -C $(TOP)/doc --no-print-directory DOCXX_ARGS='$(DOCXX_FLAGS) -A -d doc++ ' doc++process

###########################################################################
## Process the doc++ files

doc++process : FORCE
	@if [ -d doc++ ] ; then $(RM) -fr doc++/* ; else mkdir doc++ ; fi
	@cp -p $(DOCXXIMAGES) doc++
	doc++ $(DOCXX_ARGS) $(shell sed -e 's/^/$(TOP)\//' $(TOP)/Doc++Files) $(DOCXX_EXTRA_FILES)


###########################################################################
## Instalation rules

install_all: $(INSTALL) nothing
ifdef ALL_DIRS
	@ for i in $(ALL_DIRS) ; \
	do \
	   $(MAKE) --no-print-directory -C $$i install_all ; \
	done
endif

