;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                       ;;
;;;                Centre for Speech Technology Research                  ;;
;;;                     University of Edinburgh, UK                       ;;
;;;                       Copyright (c) 1996,1997                         ;;
;;;                        All Rights Reserved.                           ;;
;;;                                                                       ;;
;;;  Permission to use, copy, modify, distribute this software and its    ;;
;;;  documentation for research, educational and individual use only, is  ;;
;;;  hereby granted without fee, subject to the following conditions:     ;;
;;;   1. The code must retain the above copyright notice, this list of    ;;
;;;      conditions and the following disclaimer.                         ;;
;;;   2. Any modifications must be clearly marked as such.                ;;
;;;   3. Original authors' names are not deleted.                         ;;
;;;  This software may not be used for commercial purposes without        ;;
;;;  specific prior written permission from the authors.                  ;;
;;;                                                                       ;;
;;;  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        ;;
;;;  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      ;;
;;;  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   ;;
;;;  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     ;;
;;;  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    ;;
;;;  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   ;;
;;;  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          ;;
;;;  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       ;;
;;;  THIS SOFTWARE.                                                       ;;
;;;                                                                       ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;   CART trees for predicting Tilt accents and boundaries
;;;   These were trained from f2b
;;;

;;; Derived from f2b Tobi data
;;; wagon -data acc_tb.data.train.train -test acc_tb.data.train.test 
;;;    -desc acc_tb.desc -stop 30 -stepwise -output acc_tb.30.tree
;;; Dataset of 10595 vectors of 37 parameters from: acc_tb.data.train.train
;;; Dataset of 1177 vectors of 37 parameters from: acc_tb.data.train.test
;;; FEATURE    3 stress: 0.8097
;;; FEATURE    4 Word.gpos: 0.8522
;;; FEATURE    5 p.position_type: 0.8598
;;; FEATURE    6 p.stress: 0.8743
;;; FEATURE    7 syl_out: 0.8785
;;; FEATURE    8 p.syl_break: 0.8802
;;;               NON    
;;;         NONE 699  104  803      [699/803]      87.049
;;;            a  37  337  374      [337/374]      90.107
;;;              736  441 
;;; total 1177 correct 1036.000 88.020%
;;;
;;; wagon_test -data acc_tb.data.test -desc acc_tb.desc -tree acc_tb.30.tree 
;;;              NON    
;;;        NONE 736  124  860      [736/860]      85.581
;;;           a  33  415  448      [415/448]      92.634
;;;             769  539 
;;; total 1308 correct 1151.000 87.997%

(set! f2b_tilt_accent_cart_tree
'
;; these first few lines are hand written to deal with emphasis (from ssml)
((Word.Token.EMPH is 1)
 (((NONE 0.0) (a 1)))
 ((n.Word.Token.EMPH is 1)
  (((NONE 1.0) (a 0)))
  ((p.Word.Token.EMPH is 1)
   (((NONE 1.0) (a 0)))
((Word.gpos is cc)
 (((NONE 0.987013) (a 0.012987) NONE))
 ((stress is 0)
  (((NONE 0.969906) (a 0.0300944) NONE))
  ((Word.gpos is in)
   (((NONE 0.806452) (a 0.193548) NONE))
   ((p.position_type is 0)
    (((NONE 0.190476) (a 0.809524) a))
    ((Word.gpos is wp)
     (((NONE 0.787879) (a 0.212121) NONE))
     ((Word.gpos is aux)
      (((NONE 0.769231) (a 0.230769) NONE))
      ((Word.gpos is content)
       ((p.syl_break is 4)
        (((NONE 0.210526) (a 0.789474) a))
        ((p.position_type is single)
         (((NONE 0.205154) (a 0.794846) a))
         ((p.syl_break is 3)
          (((NONE 0.257426) (a 0.742574) a))
          ((p.syl_break is 0)
           ((p.stress is 0)
            ((p.position_type is initial)
             (((NONE 0.165289) (a 0.834711) a))
             ((syl_out < 4.8)
              ((syl_out < 0.4)
               (((NONE 0.879518) (a 0.120482) NONE))
               ((syl_out < 2.2)
                ((syl_out < 1.1)
                 (((NONE 0.449438) (a 0.550562) a))
                 (((NONE 0.551724) (a 0.448276) NONE)))
                (((NONE 0.612245) (a 0.387755) NONE))))
              (((NONE 0.677419) (a 0.322581) NONE))))
            (((NONE 0.785714) (a 0.214286) NONE)))
           (((NONE 0.289631) (a 0.710369) a))))))
       ((syl_out < 9.9)
        ((p.syl_break is 3)
         (((NONE 0.916667) (a 0.0833333) NONE))
         ((Word.gpos is det)
          (((NONE 0.365854) (a 0.634146) a))
          (((NONE 0.81746) (a 0.18254) NONE))))
        (((NONE 0.975) (a 0.025) NONE))))))))))


)))
)

;;;
;;; 
;;; wagon -data acc_tb_b2.data.train.train -test acc_tb_b2.data.train.test 
;;;   -desc acc_tb_b.desc -stop 25 -stepwise -output acc_tb_b2.25.tree 
;;; duplicated all fb/rb entries and extra 4 times
;;;
;;; FEATURE    2 syl_break: 0.8469
;;; FEATURE    3 n.Word.n.gpos: 0.8496
;;; FEATURE    4 syl_in: 0.8507
;;; FEATURE    5 p.Word.n.gpos: 0.8611
;;; FEATURE    6 p.Segment:num: 0.8727
;;; FEATURE    7 lisp_last_stress: 0.8765
;;; FEATURE    8 Segment:num: 0.8809
;;; FEATURE    9 Word.p.gpos: 0.8908
;;; FEATURE    10 p.stress: 0.8941
;;; FEATURE    11 Word.gpos: 0.8952
;;;               NON      
;;;         NONE1009    1    0 1010      [1009/1010]      99.901
;;;           fb   3  469   62  534      [469/534]      87.828
;;;           rb   1  124  153  278      [153/278]      55.036
;;;
;;; wagon_test -data acc_tb_b.data.test -desc acc_tb_b.desc
;;;        -tree acc_tb_b2.25.tree
;;;              NON      
;;;        NONE1122    0    0 1122      [1122/1122]     100.000
;;;          fb   1  106   14  121      [106/121]      87.603
;;;          rb   1   42   22   65      [22/65]      33.846
;;;            1124  148   36 
;;; total 1308 correct 1250.000 95.566%

(set! f2b_tilt_boundary_cart_tree
'
((Word.gpos is det)
 (((NONE 0.969984) (fb 0.0173776) (rb 0.0126382) NONE))
 ((p.Segment:num < 0.6)
  (((NONE 0.951807) (fb 0) (rb 0.0481928) NONE))
  ((Word.p.gpos is 0)
   (((NONE 0.945946) (fb 0.0202703) (rb 0.0337838) NONE))
   ((syl_break is 4)
    ((n.Word.n.gpos is 0)
     (((NONE 0) (fb 0.980851) (rb 0.0191489) fb))
     ((Segment:num < 5.5)
      ((n.Word.n.gpos is wp)
       (((NONE 0) (fb 0.804878) (rb 0.195122) fb))
       ((p.Word.n.gpos is cc)
        ((Segment:num < 3)
         ((n.Word.n.gpos is det)
          (((NONE 0) (fb 0.921569) (rb 0.0784314) fb))
          ((n.Word.n.gpos is in)
           (((NONE 0) (fb 0.882353) (rb 0.117647) fb))
           ((p.Segment:num < 1.3)
            (((NONE 0) (fb 0.862069) (rb 0.137931) fb))
            ((syl_in < 7.3)
             ((syl_in < 4.6)
              ((Segment:num < 2)
               ((Word.p.gpos is content)
                (((NONE 0) (fb 0.361111) (rb 0.638889) rb))
                (((NONE 0) (fb 0.5) (rb 0.5) fb)))
               (((NONE 0) (fb 0.704918) (rb 0.295082) fb)))
              (((NONE 0) (fb 0.808824) (rb 0.191176) fb)))
             (((NONE 0) (fb 0.78125) (rb 0.21875) fb))))))
         (((NONE 0) (fb 0.962406) (rb 0.037594) fb)))
        ((Word.p.gpos is aux)
         ((syl_in < 5.8)
          ((p.Segment:num < 2.2)
           ((Segment:num < 3.2)
            ((p.stress is 0)
             (((NONE 0) (fb 0.272727) (rb 0.727273) rb))
             (((NONE 0) (fb 0.714286) (rb 0.285714) fb)))
            (((NONE 0) (fb 0.75) (rb 0.25) fb)))
           (((NONE 0) (fb 0.923077) (rb 0.0769231) fb)))
          (((NONE 0) (fb 0.943396) (rb 0.0566038) fb)))
         ((lisp_last_stress < 2.5)
          ((p.Segment:num < 3.5)
           ((n.Word.n.gpos is to)
            ((Segment:num < 2.3)
             (((NONE 0) (fb 0.444444) (rb 0.555556) rb))
             (((NONE 0) (fb 0.815385) (rb 0.184615) fb)))
            ((Word.p.gpos is cc)
             ((syl_in < 4.6)
              ((p.stress is 0)
               (((NONE 0) (fb 0.275862) (rb 0.724138) rb))
               (((NONE 0) (fb 0.724138) (rb 0.275862) fb)))
              (((NONE 0) (fb 0.918367) (rb 0.0816327) fb)))
             ((Segment:num < 4.2)
              ((n.Word.n.gpos is cc)
               (((NONE 0) (fb 0.344828) (rb 0.655172) rb))
               ((p.Word.n.gpos is det)
                ((Segment:num < 3.1)
                 ((syl_in < 5)
                  ((Segment:num < 2)
                   ((p.stress is 0)
                    (((NONE 0) (fb 0.185185) (rb 0.814815) rb))
                    (((NONE 0) (fb 0.638298) (rb 0.361702) fb)))
                   (((NONE 0) (fb 0.243243) (rb 0.756757) rb)))
                  (((NONE 0) (fb 0.801802) (rb 0.198198) fb)))
                 (((NONE 0) (fb 0.916667) (rb 0.0833333) fb)))
                ((p.Segment:num < 1.2)
                 ((Word.p.gpos is in)
                  (((NONE 0) (fb 0.833333) (rb 0.166667) fb))
                  ((p.Word.n.gpos is to)
                   (((NONE 0) (fb 0.8) (rb 0.2) fb))
                   ((Segment:num < 1.3)
                    (((NONE 0) (fb 0.764706) (rb 0.235294) fb))
                    ((n.Word.n.gpos is in)
                     (((NONE 0) (fb 0.777778) (rb 0.222222) fb))
                     ((Word.p.gpos is det)
                      (((NONE 0) (fb 0.75) (rb 0.25) fb))
                      ((Segment:num < 3)
                       ((syl_in < 9.1)
                        ((n.Word.n.gpos is det)
                         (((NONE 0) (fb 0.673077) (rb 0.326923) fb))
                         ((lisp_last_stress < 1.2)
                          ((syl_in < 2.6)
                           (((NONE 0) (fb 0.321429) (rb 0.678571) rb))
                           ((p.Word.n.gpos is content)
                            (((NONE 0) (fb 0.425287) (rb 0.574713) rb))
                            (((NONE 0) (fb 0.692308) (rb 0.307692) fb))))
                          ((p.Word.n.gpos is content)
                           (((NONE 0) (fb 0.828125) (rb 0.171875) fb))
                           (((NONE 0) (fb 0.463415) (rb 0.536585) rb)))))
                        (((NONE 0) (fb 0.3) (rb 0.7) rb)))
                       (((NONE 0) (fb 0.730769) (rb 0.269231) fb))))))))
                 ((n.Word.n.gpos is in)
                  ((syl_in < 6.4)
                   ((p.Segment:num < 2.1)
                    (((NONE 0) (fb 0.757282) (rb 0.242718) fb))
                    ((syl_in < 2.4)
                     (((NONE 0) (fb 0.7) (rb 0.3) fb))
                     (((NONE 0) (fb 0.4) (rb 0.6) rb))))
                   (((NONE 0) (fb 0.804348) (rb 0.195652) fb)))
                  ((p.Word.n.gpos is pps)
                   (((NONE 0) (fb 0.724138) (rb 0.275862) fb))
                   ((p.Word.n.gpos is aux)
                    ((syl_in < 3)
                     (((NONE 0) (fb 0.16) (rb 0.84) rb))
                     ((syl_in < 6.2)
                      ((n.Word.n.gpos is content)
                       ((lisp_last_stress < 0.2)
                        (((NONE 0) (fb 0.84) (rb 0.16) fb))
                        ((Segment:num < 2.2)
                         (((NONE 0) (fb 0.736842) (rb 0.263158) fb))
                         (((NONE 0) (fb 0.214286) (rb 0.785714) rb))))
                       (((NONE 0) (fb 0.142857) (rb 0.857143) rb)))
                      (((NONE 0) (fb 0.186047) (rb 0.813953) rb))))
                    ((Segment:num < 3.1)
                     ((Word.p.gpos is to)
                      (((NONE 0) (fb 0.290909) (rb 0.709091) rb))
                      ((Word.p.gpos is pps)
                       ((syl_in < 5.5)
                        ((p.stress is 0)
                         (((NONE 0) (fb 0.8) (rb 0.2) fb))
                         (((NONE 0) (fb 0.388889) (rb 0.611111) rb)))
                        (((NONE 0) (fb 0.866667) (rb 0.133333) fb)))
                       ((n.Word.n.gpos is pps)
                        ((Segment:num < 2)
                         (((NONE 0) (fb 0.4) (rb 0.6) rb))
                         (((NONE 0) (fb 0.875) (rb 0.125) fb)))
                        ((Word.p.gpos is in)
                         ((lisp_last_stress < 0.2)
                          (((NONE 0) (fb 0.763975) (rb 0.236025) fb))
                          ((p.Segment:num < 2.1)
                           (((NONE 0) (fb 0.326531) (rb 0.673469) rb))
                           ((p.Word.n.gpos is content)
                            ((Segment:num < 2)
                             (((NONE 0) (fb 0.333333) (rb 0.666667) rb))
                             (((NONE 0) (fb 0.757576) (rb 0.242424) fb)))
                            (((NONE 0) (fb 0.846154) (rb 0.153846) fb)))))
                         ((n.Word.n.gpos is md)
                          (((NONE 0) (fb 0.375) (rb 0.625) rb))
                          ((syl_in < 1.8)
                           ((syl_in < 0.1)
                            (((NONE 0) (fb 0.125) (rb 0.875) rb))
                            ((p.Segment:num < 2.1)
                             (((NONE 0) (fb 0.344262) (rb 0.655738) rb))
                             (((NONE 0) (fb 0.647059) (rb 0.352941) fb))))
                           ((lisp_last_stress < 0.2)
                            ((syl_in < 9)
                             ((Segment:num < 2)
                              (((NONE 0) (fb 0.755906) (rb 0.244094) fb))
                              ((p.Word.n.gpos is in)
                               (((NONE 0) (fb 0.758621) (rb 0.241379) fb))
                               ((Word.p.gpos is content)
                                ((syl_in < 5.6)
                                 ((p.stress is 0)
                                  (((NONE 0) (fb 0.347222) (rb 0.652778) rb))
                                  ((syl_in < 2.3)
                                   (((NONE 0) (fb 0.459459) (rb 0.540541) rb))
                                   (((NONE 0) (fb 0.666667) (rb 0.333333) fb))))
                                 (((NONE 0) (fb 0.641026) (rb 0.358974) fb)))
                                (((NONE 0) (fb 0.704918) (rb 0.295082) fb)))))
                             (((NONE 0) (fb 0.916667) (rb 0.0833333) fb)))
                            ((p.stress is 0)
                             ((syl_in < 8.4)
                              ((p.Word.n.gpos is in)
                               (((NONE 0) (fb 0.153846) (rb 0.846154) rb))
                               (((NONE 0) (fb 0.68) (rb 0.32) fb)))
                              (((NONE 0) (fb 0.1) (rb 0.9) rb)))
                             ((Word.p.gpos is det)
                              ((p.Word.n.gpos is in)
                               (((NONE 0) (fb 0.1875) (rb 0.8125) rb))
                               ((p.Word.n.gpos is content)
                                (((NONE 0) (fb 0.611111) (rb 0.388889) fb))
                                (((NONE 0) (fb 0.322581) (rb 0.677419) rb))))
                              ((p.Word.n.gpos is to)
                               (((NONE 0) (fb 0.685714) (rb 0.314286) fb))
                               ((p.Word.n.gpos is md)
                                (((NONE 0) (fb 0.348837) (rb 0.651163) rb))
                                ((syl_in < 6.8)
                                 ((Segment:num < 1.2)
                                  (((NONE 0) (fb 0.684211) (rb 0.315789) fb))
                                  ((Segment:num < 2.1)
                                   ((p.Word.n.gpos is in)
                                    (((NONE 0.011236) (fb 0.741573) (rb 0.247191) fb))
                                    ((p.Segment:num < 2.1)
                                     (((NONE 0) (fb 0.68) (rb 0.32) fb))
                                     ((syl_in < 3.2)
                                      (((NONE 0) (fb 0.470588) (rb 0.529412) rb))
                                      (((NONE 0) (fb 0.678571) (rb 0.321429) fb)))))
                                   ((n.Word.n.gpos is content)
                                    ((syl_in < 3.2)
                                     (((NONE 0) (fb 0.68254) (rb 0.31746) fb))
                                     ((syl_in < 5.2)
                                      ((p.Word.n.gpos is content)
                                       (((NONE 0) (fb 0.764706) (rb 0.235294) fb))
                                       (((NONE 0) (fb 0.32) (rb 0.68) rb)))
                                      (((NONE 0) (fb 0.395833) (rb 0.604167) rb))))
                                    (((NONE 0) (fb 0.68) (rb 0.32) fb)))))
                                 ((n.Word.n.gpos is content)
                                  ((syl_in < 10.3)
                                   ((p.Segment:num < 2.1)
                                    (((NONE 0) (fb 0.47619) (rb 0.52381) rb))
                                    (((NONE 0) (fb 0.7625) (rb 0.2375) fb)))
                                   (((NONE 0) (fb 0.346154) (rb 0.653846) rb)))
                                  (((NONE 0) (fb 0.72) (rb 0.28) fb)))))))))))))))
                     ((Word.p.gpos is det)
                      (((NONE 0) (fb 0.772727) (rb 0.227273) fb))
                      ((n.Word.n.gpos is aux)
                       (((NONE 0) (fb 0.787879) (rb 0.212121) fb))
                       ((p.Word.n.gpos is wp)
                        (((NONE 0) (fb 0.703704) (rb 0.296296) fb))
                        ((lisp_last_stress < 0.2)
                         ((p.Word.n.gpos is in)
                          (((NONE 0) (fb 0.375) (rb 0.625) rb))
                          ((syl_in < 6)
                           ((n.Word.n.gpos is det)
                            (((NONE 0) (fb 0.666667) (rb 0.333333) fb))
                            ((syl_in < 4.5)
                             ((syl_in < 2.4)
                              ((Word.p.gpos is content)
                               (((NONE 0) (fb 0.581081) (rb 0.418919) fb))
                               (((NONE 0.0208333) (fb 0.333333) (rb 0.645833) rb)))
                              (((NONE 0.011236) (fb 0.719101) (rb 0.269663) fb)))
                             (((NONE 0) (fb 0.75) (rb 0.25) fb))))
                           ((syl_in < 7.2)
                            (((NONE 0) (fb 0.909091) (rb 0.0909091) fb))
                            (((NONE 0) (fb 0.444444) (rb 0.555556) rb)))))
                         ((Word.p.gpos is content)
                          ((p.Segment:num < 2.1)
                           (((NONE 0) (fb 0.8) (rb 0.2) fb))
                           ((syl_in < 5.6)
                            (((NONE 0.027027) (fb 0.72973) (rb 0.243243) fb))
                            (((NONE 0) (fb 0.434783) (rb 0.565217) rb))))
                          (((NONE 0) (fb 0.803571) (rb 0.196429) fb))))))))))))))
              ((n.Word.n.gpos is in)
               (((NONE 0) (fb 0.848485) (rb 0.151515) fb))
               ((p.Segment:num < 1.2)
                (((NONE 0) (fb 0.759259) (rb 0.240741) fb))
                ((p.Word.n.gpos is content)
                 (((NONE 0.00526316) (fb 0.805263) (rb 0.189474) fb))
                 ((syl_in < 4)
                  (((NONE 0) (fb 0.225806) (rb 0.774194) rb))
                  ((syl_in < 6.1)
                   (((NONE 0) (fb 0.733333) (rb 0.266667) fb))
                   (((NONE 0) (fb 0.4) (rb 0.6) rb))))))))))
           ((Segment:num < 4.2)
            ((n.Word.n.gpos is in)
             (((NONE 0) (fb 0.85) (rb 0.15) fb))
             ((Word.p.gpos is in)
              (((NONE 0) (fb 0.807692) (rb 0.192308) fb))
              ((syl_in < 7.8)
               ((Segment:num < 3.1)
                ((Segment:num < 2)
                 ((p.stress is 0)
                  (((NONE 0) (fb 0.2) (rb 0.8) rb))
                  ((syl_in < 2.1)
                   (((NONE 0) (fb 0.666667) (rb 0.333333) fb))
                   ((syl_in < 3.4)
                    (((NONE 0) (fb 0.678571) (rb 0.321429) fb))
                    ((p.Word.n.gpos is content)
                     (((NONE 0) (fb 0.419355) (rb 0.580645) rb))
                     (((NONE 0) (fb 0.609375) (rb 0.390625) fb))))))
                 (((NONE 0) (fb 0.755) (rb 0.245) fb)))
                (((NONE 0) (fb 0.79845) (rb 0.20155) fb)))
               (((NONE 0) (fb 0.753846) (rb 0.246154) fb)))))
            (((NONE 0) (fb 0.882353) (rb 0.117647) fb))))
          (((NONE 0) (fb 0.857143) (rb 0.142857) fb))))))
      (((NONE 0) (fb 0.916667) (rb 0.0833333) fb))))
    (((NONE 1) (fb 0) (rb 0) NONE))))))


)

(provide 'tilt_ab)
