 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/
 /*                                                                       */
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)             */
 /*                   Date: Mon Mar 17 1997                               */
 /* -------------------------------------------------------------------   */
 /*                                                                       */
 /* Template containing common code for objects which can be subtyped.    */
 /*                                                                       */
 /*************************************************************************/

#include "SubtypedObject.h"

template <class Base> 
int SubtypedObject<Base>::legal_type(EST_String name)
{
  int i;
  for(i=0; SubtypedObject<Base>::subtypes[i].name != NULL ; i++)
      if (name == SubtypedObject<Base>::subtypes[i].name)
	return 1;

  return 0;
}

template <class Base> 
Base *SubtypedObject<Base>::create(EST_String type)
{
  int i;
  Base *it=NULL;

  for(i=0; SubtypedObject<Base>::subtypes[i].name != NULL ; i++)
    {
      if (type == SubtypedObject<Base>::subtypes[i].name)
	{
	  it = (SubtypedObject<Base>::subtypes[i].create)();
	  break;
	}
    }

  if (!it)
    {
      // create an untyped one -- testing only
      printf("Base:: unknown type %s, creating an abstract one\n", (const char *)type);
      it = new Base;
    }

  return it;
}

template<class Base>
Base *SubtypedObject<Base>::open(EST_String filename)
{
  int i;
  FILE *stream = fopen(filename, "rb");

  if (!stream)
    return NULL;

  for(i=0; SubtypedObject<Base>::subtypes[i].name != NULL ; i++)
    {
      if ((SubtypedObject<Base>::subtypes[i].recognise)(stream))
	{
	  Base *db = (SubtypedObject<Base>::subtypes[i].create)();
	  if(!db)
	    return NULL;

	  db->set_filename(filename);

	  if (db->fill_from(stream) != format_ok)
	    {
	      delete db;
	      fclose(stream);
	      return NULL;
	    }
	  fclose(stream);
	  return db;
	}
    }
  fclose(stream);

  return NULL;
}

#if defined(INCLUDE_LISP)

template<class Base>
LISP SubtypedObject<Base>::lisp_make(LISP type, LISP properties)
{
  Base *object = Base::create(get_c_string(type));
  LISP cell=NULL;

  if (object)
    {
      cell = siod_make_typed_cell(Base::s_lisp_type, object);
      object->set_properties(properties);
    }

  //  printf("make %s %s => %x %x\n", get_c_string(type), get_c_string(name), object, cell);

  return cell;
} 

template<class Base>
LISP SubtypedObject<Base>::lisp_open(LISP lfilename)
{
  LISP cell = NULL;
  const char *filename = get_c_string(lfilename);
  Base *object = Base::open(filename);

  if (object)
      cell = siod_make_typed_cell(Base::s_lisp_type, object);

  return cell;
}

template<class Base>
void SubtypedObject<Base>::lisp_print(LISP ptr, FILE *f)
{
  Base *object = (Base *)USERVAL(ptr);
  fput_st(f,"#<");
  fput_st(f, object->type_name());
  fput_st(f," '");
  fput_st(f, object->name());
  fput_st(f,"' '");
  fput_st(f, object->subtype_name());
  fput_st(f,">");
}

template<class Base>
void SubtypedObject<Base>::lisp_print_string(LISP ptr, char *s)
{
  Base *object = (Base *)USERVAL(ptr);
  sprintf(s, "#<%s '%s' '%s'>", 
	  (const char *)object->type_name(),
	  (const char *)object->name(),
	  (const char *)object->subtype_name());
}

#endif
