 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /************************************************************************/


class Join;

#ifndef __JOIN_H__
#define __JOIN_H__

#include "EST.h"
#include "EST_TVector.h"
#include "SubtypedObject.h"
#include "Unit.h"

/** Class of joins between units.
  * <p>
  * A join is a very abstract concept, so there is little actual 
  * mechanism in this class.
  * @author Richard Caley <rjc@cstr,ed,ac,uk>
  * @version $Id: Join.h,v 1.1 1998/08/12 09:35:52 awb Exp $
  */

class Join : public SubtypedObject<Join> {

private:

  /// Previous unit.
  Unit *p_before;
  /// Next unit.
  Unit *p_after;

protected:

  /// Record previous unit.
  void set_before(Unit *u) { p_before = u; };
  /// Record previous unit.
  void set_before(Unit &u) { p_before = &u; };
  /// Record next unit.
  void  set_after(Unit *u) { p_after  = u; };
  /// Record next unit.
  void  set_after(Unit &u) { p_after  = &u; };

public:

  /// Default constructor.
  Join(void);
  /// Destructor.
  virtual ~Join(void); 

  // interface defined for subtypes.
  /**@name Subtyping */
  //@{
  /// read in from the file.
  virtual EST_read_status fill_from(FILE *stream, int binary=1);
  /// Write out to file.
  virtual EST_write_status write_to(FILE *stream, int binary=1);
  /// Record the filename.
  void set_filename(EST_String);
  //@}

  /**@name Properties */
  //@{
  /// Set a single property.
  virtual int set_property(EST_String property, ValueType value);
  //@}


  /// Get the previous unit.
  Unit *before(void) const { return p_before; };
  /// Get the next unit.
  Unit *after(void)  const { return p_after; };

  /// Point in prev unit to start join.
  virtual int from_point(void);	
  /// Point in next unit to end join.
  virtual int to_point(void);	

  /// Length of transition in arbitrary units;
  virtual int length(void);
  /// Division of transition into segments.
  virtual EST_TVector<int> segment_ends(void);
  
#if defined(INCLUDE_LISP)

  /**@name Scheme interface
    * These are the functions which are imported into Scheme. 
    */
  //@{

  /// Initialisation function.
  static void lisp_declare(void);
  //@}
#endif

  friend class SubtypedObject<Join>;
};

#endif
