 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/


#ifndef __UNITCATALOGUE_H__
#define __UNITCATALOGUE_H__

#include "UnitAux.h"
#include "SubtypedObject.h"

/** Unit catalogues map unit names to the information needed to retrieve them. 
  * 
  * One or more types of catalogue needs to be defined to go with each type
  * of database.
  * 
  * @author Richard Caley <rjc@cstr.ed.ac.uk>
  * @version $Id: UnitCatalogue.h,v 1.1 1998/08/12 09:35:52 awb Exp $
  */

class UnitCatalogue : public SubtypedObject<UnitCatalogue> {
public:
    /// An itterator can be used to step through the units.
    class Itterator {
    public:
	Itterator(void);
	virtual ~Itterator(void);
	virtual UnitName next(void);
	virtual int at_end(void);
    };
    
    /// Count entries in the catalogue.
    virtual int num_entries (void);
    /// Check to see if the unit is in the catalogue.
    virtual int has_entry(UnitName name);
    /// Return an itterator.
    Itterator *itterator(void);

    /**@name Subtyping */
    //@{
    /// Read in from the file.
    virtual EST_read_status fill_from(FILE *stream)  {(void)stream; return misc_read_error; }
    /// Write out to file.
    virtual EST_write_status write_to(FILE *stream)  {(void)stream; return misc_write_error; }
    /// Record the filename.
    void set_filename(EST_String) { }
    //@}

};
  
#endif
