/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                       Copyright (c) 1996,1997                         */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*             Author :  Alan W Black (and Paul Taylor)                  */
/*             Date   :  November 1997                                   */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/* From assigned tilt parameters generate an F0 contour and sample it    */
/* generated a number of targets                                         */
/*                                                                       */
/*=======================================================================*/
#include <stdio.h>
#include "festival.h"
#include "intonation.h"
#include "EST_tilt.h"

#if 0
static void tilt_make_tilt_stream(EST_Stream &te,EST_Stream &ie);
#endif

static void tilt_make_targets(EST_Utterance *utt, EST_Track &fz);

LISP FT_Int_Targets_Tilt_Utt(LISP utt)
{
    // Predict F0 targets 
    EST_Utterance *u = get_c_utt(utt);
    EST_Track *fz = new EST_Track;

    cerr << "Tilt: not ported to Relation architecture yet" << endl;
    festival_error();

#if 0
    u->create_stream("Tilt");
    EST_Stream &tilt_event = u->stream("Tilt");
    tilt_make_tilt_stream(tilt_event,u->stream("IntEvent"));

    tilt_synthesis(*fz,tilt_event,0.01,FALSE);
#endif

    fz->set_channel_name("F0", 0);
    fz->set_contour_type(ct_f0);

    // Save F0 in Utterance
    EST_Item *fo_si = u->create_relation("F0")->append();
    fo_si->fset("f0", fz, gc_track);

    // Sample it creating a target stream
    tilt_make_targets(u, *fz);

    return utt;
}

static void tilt_make_targets(EST_Utterance *utt, EST_Track &fz)
{
    // Build target stream by sampling values from fz
    // For each segment add a target for the middle and end
    // and also add one at the start if previous is silence
    EST_Item *seg;
    float t;

    utt->create_relation("Target");

    // Grr ... the 50s are a hack and will be removed once the
    // tilt stuff stops predicting wee numbers.

    for (seg=utt->relation("Segment")->first(); seg; seg=next(seg))
    {
	if (ph_is_silence(seg->name()))
	    continue;
	float start = ffeature(seg,"segment_start");
	float mid = ffeature(seg,"segment_mid");
	float end = ffeature(seg,"segment_end");
	if ((prev(seg) == 0) || ph_is_silence(prev(seg)->name()))
	{
	    float s = fz.a(start,0);
	    if (s > 50) add_target(utt,seg,start,s);
	}
	t = fz.a(mid,0);
	if (t > 50) add_target(utt,seg,mid,t);
	t = fz.a(end,0);
	if (t > 50) add_target(utt,seg,end,t);
    }
}    

#if 0
static void tilt_make_tilt_stream(EST_Stream &te,EST_Stream &ie)
{
    // Build a tilt_event stream from an IntEvent stream.  This
    // is just really a matter of taking the events in and converting
    // them to the tilt event format.
    EST_Item *p;
    float lend = 0;

    for(p=ie.head(); p != 0; p=next(p))
    {
	if (p->end() < lend)
	{
	    cerr << "tilt: IntEvent end " << p->name() << 
		" is before previous at " << p->end() << ", ignoring it "
		    << endl;
	}
	else
	{
	    EST_Item *tei = te.append();
	    *tei = *p;
	    tei->fset("start",lend);

	    tei->fset_val("ev:start_f0",p->f("tilt_start_f0"));
	    if ((p->name() != "c") &&
		(p->name() != "sil"))
	    {
		tei->fset_val("tilt:amp",p->f("tilt_amplitude"));
		tei->fset_val("tilt:dur",p->f("tilt_duration"));
		tei->fset_val("tilt:tilt",p->f("tilt_tilt"));
		tei->fset_val("tilt:pos",p->f("tilt_peak_pos"));
		tei->fset("int_event",1);
	    }
	}
	lend = p->end();
    }

}

#endif
