 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /************************************************************************/
 /*                                                                      */
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)            */
 /*                   Date: Wed Mar 19 1997                              */
 /* ------------------------------------------------------------------   */
 /* Unit subclass for frames which are pre cut.                          */
 /*                                                                      */
 /************************************************************************/

#include "CutFramesUnit.h"
#include "EST_ContourType.h"

CutFramesUnit::CutFramesUnit(void)
{
  p_segment_ends = NULL;
}

CutFramesUnit::~CutFramesUnit(void)
{
}

Unit *CutFramesUnit::create(void) 
{
  CutFramesUnit *unit = new CutFramesUnit;

  return unit;
}

void CutFramesUnit::property_names(EST_TList<EST_String> &list) const
{
  FramesUnit::property_names(list);
  list.append("pre_cut");
}

ValueType CutFramesUnit::property(EST_String name) const
{
  if (name == "pre_cut")
    return c_string_as_value("yes");

  return FramesUnit::property(name);
}


// Since this is cut short at the end, the endpoints from
// the database are inside the end segments. We move them
// out by an arbitrary amount. This has no practical upshot, but makes
// the logic of manipulating them equivalent to the uncut case.

EST_TVector<int> *CutFramesUnit::segment_ends(void)
{
  
  if (p_segment_ends == NULL)
    {
      EST_TVector<int> *s_e = FramesUnit::segment_ends();

      (*s_e)[0] = -1;
      (*s_e)[s_e->length()-1] = pitchmarks()->num_frames() + 1;
      p_segment_ends = s_e;
    }
      
  printf("ends for %s ", (const char *)name());
  for(int i=0; i< p_segment_ends->length(); i++)
    printf("%d ", (*p_segment_ends)[i]);
  printf("end at %d\n", length());

  return p_segment_ends;
}
