/*
 * cslibint.h -- low level I/O
 *
 * (c) Copyright 1993-1994 Adobe Systems Incorporated.
 * All rights reserved.
 * 
 * Permission to use, copy, modify, distribute, and sublicense this software
 * and its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notices appear in all copies and that
 * both those copyright notices and this permission notice appear in
 * supporting documentation and that the name of Adobe Systems Incorporated
 * not be used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  No trademark license
 * to use the Adobe trademarks is hereby granted.  If the Adobe trademark
 * "Display PostScript"(tm) is used to describe this software, its
 * functionality or for any other purpose, such use shall be limited to a
 * statement that this software works in conjunction with the Display
 * PostScript system.  Proper trademark attribution to reflect Adobe's
 * ownership of the trademark shall be given whenever any such reference to
 * the Display PostScript system is made.
 * 
 * ADOBE MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE SOFTWARE FOR
 * ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 * ADOBE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NON- INFRINGEMENT OF THIRD PARTY RIGHTS.  IN NO EVENT SHALL ADOBE BE LIABLE
 * TO YOU OR ANY OTHER PARTY FOR ANY SPECIAL, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE, STRICT LIABILITY OR ANY OTHER ACTION ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.  ADOBE WILL NOT
 * PROVIDE ANY TRAINING OR OTHER SUPPORT FOR THE SOFTWARE.
 * 
 * Adobe, PostScript, and Display PostScript are trademarks of Adobe Systems
 * Incorporated which may be registered in certain jurisdictions
 * 
 * Portions Copyright 1984, 1985, 1987, 1989  Massachusetts Institute of
 * Technology
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *  
 * Author:  Adobe Systems Incorporated and MIT X Consortium
 */
 
/*
 *	XlibInternal.h - Header definition and support file for the internal
 *	support routines (XlibInternal) used by the C subroutine interface
 *	library (Xlib) to the X Window System.
 *
 *	Warning, there be dragons here....
 */

#ifndef _CSLIBINT_H
#define _CSLIBINT_H

/* For SYSV, no gethostname, so fake it */
#include <sys/param.h>
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif

/* === MACROS === */

/*
 * NXMacroGetReq - Get the next avilable DPS request packet in the buffer and
 * return it. 
 *
 * "name" is the name of the request, e.g. PSGiveInput, etc.
 * "req" is the name of the request pointer.
 *
 */

#if defined(__STDC__) && !defined(UNIXCPP)
#define NXMacroGetReq(name, req) \
	if (dpy == xdpy) {\
	    GetReq(name, req);\
	} else {\
	    WORD64ALIGN\
	    if ((dpy->bufptr + SIZEOF(x##name##Req)) > dpy->bufmax)\
		N_XFlush(dpy);\
	    req = (x##name##Req *)(dpy->last_req = dpy->bufptr);\
	    req->reqType = X_##name;\
	    req->length = (SIZEOF(x##name##Req))>>2;\
	    dpy->bufptr += SIZEOF(x##name##Req);\
	    dpy->request++;}

#else  /* non-ANSI C uses empty comment instead of "##" for token concatenation */
#define NXMacroGetReq(name, req) \
	if (dpy == xdpy) {\
	    GetReq(name, req);\
	} else {\
	    WORD64ALIGN\
	    if ((dpy->bufptr + SIZEOF(x/**/name/**/Req)) > dpy->bufmax)\
		N_XFlush(dpy);\
	    req = (x/**/name/**/Req *)(dpy->last_req = dpy->bufptr);\
	    req->reqType = X_/**/name;\
	    req->length = (SIZEOF(x/**/name/**/Req))>>2;\
	    dpy->bufptr += SIZEOF(x/**/name/**/Req);\
	    dpy->request++;}
#endif

#if !defined(STARTITERATE) && !defined(WORD64)

#define STARTITERATE(tpvar,type,start,endcond,decr) \
  for (tpvar = (type *) start; endcond; tpvar++, decr) {
#define ENDITERATE }

#endif /* STARTITERATE */


#ifndef WORD64
#undef Data32
#define Data32(dpy, data, len) NXProcData((dpy), (char *)(data), (len))
#endif /* not WORD64 */


/* extension hooks */

extern void NXProcData();
extern void N_XEatData();		/* swallow data from server */
extern int N_XDisconnectDisplay();
extern int N_XGetHostname();
extern Status N_XUnknownNativeEvent();
extern Bool N_XUnknownWireEvent();

#if XlibSpecificationRelease > 5
# define NO_XDECLS
#endif

#ifndef NO_XDECLS
extern int _XFlush();
extern int _XRead();
extern int _XReadPad();
extern Status _XReply();
extern int _XSend();
#endif /* NO_XDECLS */

extern int N_XFlush();
extern int N_XRead();
extern int N_XReadPad();
extern Status N_XReply();
extern int N_XSend();

#endif /* _CSLIBINT_H */

