/*
 * db.h : Definitions of the database record type, and external defs of
 *	the database functions.
 *
 * George Ferguson, ferguson@cs.rochester.edu, 2 Nov 1991.
 * Version 2.0: 23 Apr 1993.
 */

#ifndef DB_H
#define DB_H

#include "pfs.h"		/* for VLINK */

#define DB_NOTYPE	0
#define DB_FILE		1
#define DB_DIRECTORY	2
#define DB_LOCATION	3
#define DB_HOST		4

typedef struct _DbEntry {
    char *name;			/* print name */
    int type;			/* DB_{FILE,DIRECTORY} */
#ifdef MSDOS
    unsigned long size;
#else
    int size;
#endif
    char *modes;		/* drwxrwxrwx + \0 */
    char *date;			/* "mmm dd yyyy\0" or "mmm dd hh:mm\0" */
    char *gt_date;		/* YYYYMMDDHHMMSSZ\0 */
    int selected;		/* Selected in browser? Where? */
    VLINK vlink;		/* Prospero VLINK for expansion */
    struct _DbEntry *entries;		/* children */
    struct _DbEntry *next,*prev;	/* siblings */
    struct _DbEntry *parent;		/* parent */
} DbEntry;

extern DbEntry*newEntry();
extern void clearEntries();
extern DbEntry *addEntry();
extern DbEntry *lastEntry();
extern DbEntry *findEntryFromString();
extern DbEntry *findEntryFromIndex();
extern int findIndexFromEntry();
extern void setEntryData(), freeEntryData();
extern void sortEntriesRecursively(), sortEntries();
extern int cmpEntryNames(), cmpEntryDates(), cmpEntryWeights();

#define DB_ISDIR(dbp) ((dbp)->type == DB_DIRECTORY)

#endif /* DB_H */
