package lib;

use 5.005_64;
use Config;

my $archname = defined($Config{'archname'}) ? $Config{'archname'} : '';
my $ver = defined($Config{'version'}) ? $Config{'version'} : '';
my @inc_version_list = defined($Config{'inc_version_list'}) ?
   reverse split / /, $Config{'inc_version_list'} : ();

our @ORIG_INC = @INC;	# take a handy copy of 'original' value
our $VERSION = '0.5564';

sub import {
    shift;

    my %names;
    foreach (reverse @_) {
	if ($_ eq '') {
	    require Carp;
	    Carp::carp("Empty compile time value given to use lib");
	}
	if (-e && ! -d _) {
	    require Carp;
	    Carp::carp("Parameter to use lib must be directory, not file");
	}
	unshift(@INC, $_);
        # Add any previous version directories we found at configure time
        foreach my $incver (@inc_version_list)
        {
            unshift(@INC, "$_/$incver") if -d "$_/$incver";
        }
	# Put a corresponding archlib directory infront of $_ if it
	# looks like $_ has an archlib directory below it.
	unshift(@INC, "$_/$archname") if -d "$_/$archname/auto";
	unshift(@INC, "$_/$ver") if -d "$_/$ver";
	unshift(@INC, "$_/$ver/$archname") if -d "$_/$ver/$archname";
    }

    # remove trailing duplicates
    @INC = grep { ++$names{$_} == 1 } @INC;
    return;
}

sub unimport {
    shift;

    my %names;
    foreach (@_) {
	++$names{$_};
	++$names{"$_/$archname"} if -d "$_/$archname/auto";
	++$names{"$_/$ver"} if -d "$_/$ver";
	++$names{"$_/$ver/$archname"} if -d "$_/$ver/$archname";
    }

    # Remove ALL instances of each named directory.
    @INC = grep { !exists $names{$_} } @INC;
    return;
}

1;
__END__

