package base;

use 5.005_64;
our $VERSION = "1.01";

sub import {
    my $class = shift;
    my $fields_base;
    my $pkg = caller(0);

    foreach my $base (@_) {
	next if $pkg->isa($base);
	push @{"$pkg\::ISA"}, $base;
	unless (exists ${"$base\::"}{VERSION}) {
	    eval "require $base";
	    # Only ignore "Can't locate" errors from our eval require.
	    # Other fatal errors (syntax etc) must be reported.
	    die if $@ && $@ !~ /^Can't locate .*? at \(eval /;
	    unless (%{"$base\::"}) {
		require Carp;
		Carp::croak("Base class package \"$base\" is empty.\n",
			    "\t(Perhaps you need to 'use' the module ",
			    "which defines that package first.)");
	    }
	    ${"$base\::VERSION"} = "-1, set by base.pm"
		unless exists ${"$base\::"}{VERSION};
	}

	# A simple test like (defined %{"$base\::FIELDS"}) will
	# sometimes produce typo warnings because it would create
	# the hash if it was not present before.
	my $fglob;
	if ($fglob = ${"$base\::"}{"FIELDS"} and *$fglob{HASH}) {
	    if ($fields_base) {
		require Carp;
		Carp::croak("Can't multiply inherit %FIELDS");
	    } else {
		$fields_base = $base;
	    }
	}
    }
    if ($fields_base) {
	require fields;
	fields::inherit($pkg, $fields_base);
    }
}

1;
