/*
 *	autosaveDialog.h - Selection dialog on recovery from autosave files
 *	Copyright (C) 2015, D Haley 

 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.

 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.

 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
// -*- C++ -*- generated by wxGlade 0.6.5 on Thu Jun  7 12:47:44 2012

#include <wx/wx.h>
// begin wxGlade: ::dependencies
// end wxGlade


#ifndef AUTOSAVEDIALOG_H
#define AUTOSAVEDIALOG_H
#include <vector>

// begin wxGlade: ::extracode
enum
{
    ID_LIST_STATES = wxID_ANY+1,
    ID_REMOVE_ALL
};
// end wxGlade


class AutosaveDialog: public wxDialog {
public:
    // begin wxGlade: AutosaveDialog::ids
    // end wxGlade

    AutosaveDialog(wxWindow* parent, int id=wxID_ANY, const wxString& title=wxT(""), const wxPoint& pos=wxDefaultPosition, const wxSize& size=wxDefaultSize, long style=wxDEFAULT_DIALOG_STYLE);

private:
    // begin wxGlade: AutosaveDialog::methods
    void set_properties();
    void do_layout();
    // end wxGlade

    //! the index of the selected item, -1 otherwise
    size_t selectedItem;

    //True if the remove all button was
    // depressed
    bool haveRemovedItems;
protected:
    // begin wxGlade: AutosaveDialog::attributes
    wxListBox* listStates;
    wxButton* btnRemoveAll;
    wxButton* btnCancel;
    wxButton* btnOK;
    // end wxGlade

    DECLARE_EVENT_TABLE();

public:
    virtual void OnListStates(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnListStatesDClick(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnRemoveAll(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnCancel(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnOK(wxCommandEvent &event); // wxGlade: <event_handler>

    //Set the items that are to be displayed in the listbox.
    void setItems(const std::vector<std::string> &items);
    //!Get the item that was selected, returning the position of the selected
    // item in the original vector
    unsigned int getSelectedItem() const { return selectedItem;};

	//Has the user require cited to remove items?
    bool removedItems() const {return haveRemovedItems;};

}; // wxGlade: end class


#endif // AUTOSAVEDIALOG_H
