# Part of the A-A-P recipe executive: remember the work specified in the recipe

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

#
# Errors
#
# It's OK to do "from Errors import *", these things are supposed to be global.
#

class NormalExit(Exception):
    """Normal exit, used for "--version", ":exit", etc."""
    def __init__(self):
        Exception.__init__(self)

class FinishRecipe(Exception):
    """Quit the current recipe, used ":finish"."""
    def __init__(self):
        Exception.__init__(self)

class UserError(Exception):
    """Error for something the user has done wrong.
       Usually causes us to exit with a non-zero value."""
    def __init__(self, args = None):
        Exception.__init__(self)
        self.args = args

class WriteAfterRead(Exception):
    """Error for writing a local variable after reading it from another scope.
    """
    def __init__(self, args = None):
        Exception.__init__(self)
        self.args = args

class InternalError(Exception):
    """Error for something wrong in our code.
       Usually causes us to exit with a non-zero value."""
    def __init__(self, args = None):
        Exception.__init__(self)
        self.args = args

class OriginUpdate(Exception):
    """An ":recipe" command updated the recipe file and throws this exception
       to cancel executing the old one."""
    def __init__(self, args = None):
        Exception.__init__(self)
        self.args = args

# vim: set sw=4 et sts=4 tw=79 fo+=l:
