# Part of the A-A-P recipe executive: Testing of :program

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

import sys, os, stat, shutil, string, glob

def runaap(args):
    res = os.system("%s ..%sMain.py %s" % (sys.argv[1], os.sep, args))
    if res:
        print "Aap exited with error value %d" % res
    return res

os.chdir("rectest")

# Create three recipes to test whether the rule scope is handled correctly.

rec1 = "rectest1.aap"
prog = "foo"
src1 = "foo.c"
src2 = "bar.c"
out = "rectest.aap.out"

def cleanup():
    for n in [ rec1, prog, src1, src2, out ]:
        try:
            os.remove(n)
        except:
            pass
    try:
	for dir in glob.glob('build-*'):
	    shutil.rmtree(dir)
    except:
	pass

cleanup()

f = open(rec1, "w")
f.write("""
:program %s : %s $BDIR/bar$OBJSUF
""" % (prog, src1))
f.close()

f = open(src1, "w")
f.write("""
#include <stdio.h>
extern char *msg;
int main() { printf(msg); return 0;}
""")
f.close()

f = open(src2, "w")
f.write("""
char *msg = "It works!\\n";
""")
f.close()

# The first time running should result in two files being copied.
res = runaap("-f %s" % rec1)

res = res + os.system(".%s%s > %s" % (os.sep, prog, out))
f = open(out)
actual = f.read()
f.close()

failed = (actual != "It works!\n")

cleanup()

sys.exit(failed)


# vim: set sw=4 et sts=4 tw=79 fo+=l:
