// $Id: rpn.cc,v 1.18 1996/12/11 21:39:41 aml Exp $

#include "calc.hh"

Range_iter::Range_iter(Range &r) {
    rg = r;
}

void Range_iter::init(Range &r) {
    rg = r;
}

void Range_iter::first(Ref &r) {
    r.col = col = rg.start.col;
    r.row = row = rg.start.row;
    
}

void Range_iter::next(Ref &r) {
    
    
    if (cell_address(row,8192) < cell_address(rg.end.row,8192)) {
        row++;
        if (row & Refmask2) row &= ~Refmask2;
        r.col = col;
        r.row = row;
    } else if (cell_address(col,8192) < cell_address(rg.end.col,8192)) {
        col++;
        if (col & Refmask2) col &= ~Refmask2;
        row = rg.start.row;
        r.col = col;
        r.row = row;
    }
    else {
        row++;
        col++;
    }
    if (row & Refmask2) row &= ~Refmask2;
    if (col & Refmask2) col &= ~Refmask2;

}

int Range_iter::last() {
    if (cell_address(col,8192) > cell_address(rg.end.col,8192) &&
        cell_address(row,8192) > cell_address(rg.end.row,8192))
        return(TRUE);
    return(FALSE);
}

Formula::Formula(short siz,char *dat) {
    int i;


    size = siz;
    formula = new char[size];
    tmp_formula = NULL;
    st_value = NULL;
    typ = FORM_FP;
    memcpy(formula,dat,size);

}

Formula::Formula() {
    tmp_formula = new char[MAX_FORMULA_SIZE];
    formula = NULL;
    size = 0;

    value = 0.0;
    st_value = NULL;
    typ = FORM_FP;

}

Formula::~Formula() {
    delete [] tmp_formula;
    delete [] formula;
}

Formula::Formula(Formula &right) {
    formula = strnsave(right.formula,right.size);
    tmp_formula = strnsave(right.tmp_formula,MAX_FORMULA_SIZE);
    st_value = strsave(right.st_value);
    size = right.size;
    value = right.value;
}


void Formula::operator=(Formula &r) {
    value = r.value;
    size = r.size;
    
    formula = strnsave(r.formula,r.size);
    tmp_formula = strnsave(r.tmp_formula,MAX_FORMULA_SIZE);
    st_value = strsave(r.st_value);
}



short cell_address(short x,short base) {
    short res;

    if (x & Refmask) {
        if (!(x & Refmask3)) {/* Number is positive */
            x &= ~Refmask;
        }
        else { /* Number is negative */
            x |= Refmask2;
        }
        res = base+x;
    }
    else 
        res = x;

    return(res);
}


Range *range_reference(char *name1, char *name2) {
    static Range rg;
    Ref *ref;

    ref = cell_reference(name1);
    rg.start = *ref;

    ref = cell_reference(name2);
    rg.end = *ref;

    return(&rg);

    
}

Ref *cell_reference(char *name) {
    static Ref ref;
    char *norm;

    norm = normal_cell_name(name);


    ref.col = cellcol(norm);
    if (norm[0] == '$')
        ref.col &= ~Refmask;
    else
        ref.col |= Refmask;;

    ref.row = cellrow(norm);
    if (find_char(norm+1,'$') != -1) 
        ref.row &= ~Refmask;
    else 
        ref.row |= Refmask;


    return(&ref);
    
}

void change_col_to_relative(Ref *pt_ref1, short col) {
    short c;

    c = pt_ref1->col & ~(Refmask);
    c = c-col;
    pt_ref1->col = c;
    pt_ref1->col |= Refmask;
    pt_ref1->col &= ~Refmask2;
}

void change_row_to_relative(Ref *pt_ref1, short row) {
    short r;

    r = pt_ref1->row & ~(Refmask);
    r = r-row;
    pt_ref1->row = r;
    pt_ref1->row |= Refmask;
    pt_ref1->row &= ~Refmask2;

}

/* 
$Log: rpn.cc,v $
Revision 1.18  1996/12/11 21:39:41  aml
Sumif implemented.
Diverse time functions implemented.
Fixed needtoscroll2 to avoid out of control scroll.

Revision 1.17  1996/09/19 12:16:50  aml
Created row and column insert.
Fixed small problem with display of vergrown cells.

Revision 1.16  1996/08/29 12:05:15  aml
Fixed problem with initialization of formulas.
Insertion in entry is now done properly.
Focus is slightly better handled.
Fixed serious problem when canvas changes name and old
references exist. Also removed double call to redraw that
was slowing things a lot.

Revision 1.15  1996/08/28 17:17:08  aml
Load and save now accept string_value for formula cells.
This fixes previous thought problem of formula values not
being stored.
Functions upper,lower and proper created.
Function if can now return labels.
Fixed problem with function count.
Reasonably stable version, very used to manipulate notas.wk1.

Revision 1.14  1996/04/23 09:42:41  aml
Data structures for ordered scans of rows and columns are in place.
Cell overlap is working.
Forward cell dependences inserted. Automatic recalculation created.
Uniformizaed label entry procedure.

// Revision 1.13  1996/03/01  13:08:29  aml
// Stack references are now pushed instead of double value.
// Fixed problem with integers too large on formulas.
// Scroll with cursors now works better.
//
Revision 1.12  1996/02/16 18:03:57  aml
Fixed a memory bug in formula copy with purify.
Fixed a few minor bugs. Functional, stable version.

Revision 1.11  1996/02/13 21:55:11  aml
Fixed problems with change to elf.
RangeCopy created. Works !
Pressed mouse leaving canvas will cause scroll. Works, but needs to
keep moving.

// Revision 1.10  1996/02/13  12:03:21  aml
// Fixed bug with range definition via mouse.
// Fixed bug in range iterators.
//
// Revision 1.9  1996/01/27  23:10:17  aml
// CellCopy created.
// CellGet fixed.
// Tcl range operators created.
// User interface improved. Cell references and ranges
// can now be defined with the mouse.
//
// Revision 1.8  1996/01/11  22:48:40  aml
// Range iterators created.
// Functions sum, max and min now work properly.
// Negative numbers now allowed by flex (oops :-)
//
// Revision 1.7  1996/01/07  09:07:25  aml
// Sheet::save and Sheet::load created.
// Program can now write and read wk1 files.
// Slight changes made to relative references. Bit 14 is now always 0.
//
// Revision 1.6  1996/01/05  23:05:54  aml
// Cell references evaluated.
// Spreadsheet is recalculated at every change, by an arbitrary order.
// Reformulated program structure. Evaluation and reverse parsing
// are member functions of Sheet.
//
// Revision 1.5  1996/01/04  20:27:12  aml
// Range references parsed and reverse parsed.
//
// Revision 1.4  1996/01/03  23:07:06  aml
// Absolute and relative references to cells introduced.
// They are parsed and reverse parsed, not yet evaluated.
//
// Revision 1.3  1996/01/02  16:22:05  aml
// Formula compilation, evaluation and decompilation now work.
// Cells can be of type label, numerical formula or numbers.
//
// Revision 1.2  1995/12/30  16:40:23  aml
// First cut of formula compilation.
//
// Revision 1.1  1995/12/30  14:47:09  aml
// Initial revision
//
*/
