#
# $Id: sheet.tcl,v 1.12 1998/08/06 21:08:34 aml Exp $
#

proc newSpreadsheet {{name none}} {
    global sheetCnt activeSheet
    source [xxl_library]/globalvars.tcl
    
    if {$name != "none"}  {
    } else {
        set name "sheet$sheetCnt"
        incr sheetCnt
    }                
    set activeSheet $name
    NewSheet $name
    mkCanvas $name  
#    redrawCanvas $name
    set existingSheets "$existingSheets $name"
}

proc deleteSpreadsheet {name} {
    source [xxl_library]/globalvars.tcl

    if {[DeleteSheet $name] == 1} return 
    destroy .$name
    set i [lsearch $existingSheets $name]
    set existingSheets [lreplace $existingSheets $i $i]
    puts "Sheets : $existingSheets"
    if {$existingSheets == ""} {destroy .}
    
}

proc changeSheetName {name1 name2} {
    source "[xxl_library]/globalvars.tcl"

    

    if {$name1 == $name2} return

    set i [lsearch $existingSheets $name1]
    set existingSheets [lreplace $existingSheets $i $i $name2]

    ChangeSheetName $name1 $name2
    set activeSheet $name2
    SetActiveSheet $name2
    mkCanvas $name2 0

    set s [wm geom .$name1]
    wm geom .$name2 $s

    tkwait visib .$name2
#    RedrawSheet $name2
    destroy .$name1
    update 

}



#
# $Log: sheet.tcl,v $
# Revision 1.12  1998/08/06 21:08:34  aml
# Released alpha version of Abacus.
#
# Revision 1.11  1996/09/04 14:29:54  aml
# Fixed double redrawing of sheets that was taking place.
# Fixed a item reference problem when the sheet is redrawn.
# Fixed misplacement of row labels.
# Created first version of format toolbar.
#
# Revision 1.10  1996/08/24 10:16:02  aml
# Scroll almost fixed. We are missing scroll steps.
# Several sheets work again, but need to be fixed right.
#
# Revision 1.9  1996/03/07  20:32:56  aml
# Created print range ability.
# Set in gray non-working menus.
# Created RangeKill command.
# Created round function and macros for single argument functions.
#
# Revision 1.8  1996/03/01 13:08:45  aml
# Stack references are now pushed instead of double value.
# Fixed problem with integers too large on formulas.
# Scroll with cursors now works better.
#
# Revision 1.7  1996/02/19 15:47:35  aml
# Fixed abnormality with mouse click.
# Variable width columns implemented, but not yet saved.
# Labels are now a lex element, fixing some aberrant behavior that existed.
#
# Revision 1.6  1996/02/16  23:09:33  aml
# Improved user interf state machine.
# Centralized range definitions.
# Range defined outiside current view work properly.
#
# Revision 1.5  1996/01/11  22:48:48  aml
# Range iterators created.
# Functions sum, max and min now work properly.
# Negative numbers now allowed by flex (oops :-)
#
# Revision 1.4  1996/01/09  18:34:49  aml
# Load, save, open, close and exit now work properly (hopefuly).
# Sheet utility functions also work : SheetExists, SheetEmpty, SheetModified
#
# Revision 1.3  1995/12/14  12:13:03  aml
# Version 0.4.2
#
# Revision 1.2  1995/11/08  22:24:24  aml
# None
#
#