/* $Id: event.hh,v 1.1 1998/08/17 20:23:26 cthulhu Exp $ */

#ifndef _EVENT_DOT_HH_
#define _EVENT_DOT_HH_

#include "cell.hh"
#include "list.hh"

#define UNDO_DEPTH 20

class Event{
public:
  virtual void UndoEvent()=0;
  virtual void RedoEvent()=0;
};

/********************* Cell Events ********************/

class CellSetEvent: public Event {
  short col,row;
  Sheet *sheet;
  Cell cell_sav;
public:
  CellSetEvent(Sheet *, Cell *);
  void UndoEvent();
  void RedoEvent();
};

/***********Col/Row Insert and Delete Events***********/

class ColRowInsertEvent: public Event {
  char col_or_row;
  short cr_ind,cr_num;
  Sheet *sheet;
  Lista<Event> event_l;
  Node<Event> *event_it;

public:
  ColRowInsertEvent(Sheet *,char,short,short);
  void UndoEvent();
  void RedoEvent();

  void RegisterGraphEvent(Event *);
  void UndoGraph();
  void RedoGraph();

};

class ColRowDeleteEvent: public Event {
  char col_or_row;
  short cr_ind,cr_num;
  Sheet *sheet;
  array<Cell> lastcells;
  Lista<Event> event_l;
  Node<Event> *event_it;

public:
  ColRowDeleteEvent(Sheet *,char,short,short);
  void UndoEvent();
  void RedoEvent();

  void RegisterGraphEvent(Event *);
  void UndoGraph();
  void RedoGraph();
};

/******************** Range Events ********************/

class RangeEvent: public Event {
  Sheet *sheet;
  short x_start,y_start,x_end,y_end;
  Cell *cell_sav;
  array<Cell *> cells_sav;
public:
  RangeEvent(Sheet *,short,short,short=-1,short=-1);
  ~RangeEvent();
  void UndoEvent();
  void RedoEvent();
  short GetXStart();
  short GetYStart();
  short GetXEnd();
  short GetYEnd();
  Sheet *GetSheet();
};

class RangeMoveEvent: public Event {
  RangeEvent *from,*to;
public:
  RangeMoveEvent(RangeEvent *,RangeEvent *);
  ~RangeMoveEvent();
  void UndoEvent();
  void RedoEvent();
};

/******************* Format Events ********************/

class SetFormatEvent: public Event {
  Sheet *sheet;
  short startcol,startrow,endcol,endrow;
  Format lastformat;
  array<Format> lastformats;
public:
  SetFormatEvent(Sheet *,short,short,short =-1,short =-1);
  ~SetFormatEvent();
  void UndoEvent();
  void RedoEvent();
};

/***************** Geometry Events ********************/

class SetColWidthEvent: public Event {
  Sheet *sheet;
  short col;
  int width;
public:
  SetColWidthEvent(Sheet *,short);
  void UndoEvent();
  void RedoEvent();
};

class SetRowHeightEvent: public Event {
  Sheet *sheet;
  short row;
  int height;
public:
  SetRowHeightEvent(Sheet *,short);
  void UndoEvent();
  void RedoEvent();
};

/***************** Graphics Events ********************/

class SetGraphEvent: public Event {
  Sheet *sheet;
  Graph *gr;
public:
  SetGraphEvent(Sheet *,Graph);
  ~SetGraphEvent();
  void UndoEvent();
  void RedoEvent();
};

class DelGraphEvent: public Event {
  Sheet *sheet;
  Graph *gr;
public:
  DelGraphEvent(Sheet *,Graph);
  ~DelGraphEvent();
  void UndoEvent();
  void RedoEvent();
};

class ChangeGraphEvent: public Event {
  Sheet *sheet;
  Graph *gr;

public:
  ChangeGraphEvent(Sheet *,Graph);
  ~ChangeGraphEvent();
  void UndoEvent();
  void RedoEvent();
};

#endif

/* $Log: event.hh,v $
 * Revision 1.1  1998/08/17 20:23:26  cthulhu
 * Initial revision
 * */

