// $Header: /home/abyss/prj/include/RCS/string.hh,v 1.2 1996/01/02 16:22:09 aml Exp $
/**************************************************************

Program: SMOG - Selection of Minimal Ordered Graphs

Author: Arlindo Oliveira (aml@ic.eecs.berkeley.edu)

Copyright 1994 University of California Berkeley / CAD Group

This software may not be distributed without 
permission of the copyright holder.


****************************************************************/

#ifndef _STRING_DOT_HH_
#define _STRING_DOT_HH_

#include "string.h"
#include "utils.hh"

class string {
  public:
    char *ptr;
    string(int n) {
        ptr = new char[n];
    }
    string() {
        ptr = NULL;
    }
    string(char *st) {
        int size = strlen(st)+1;
        ptr = new char[size];
        strcpy(ptr,st);
    }
    ~string(){
        delete [] ptr;
    }
    operator char*() {return(ptr);}
    void operator+=(const string &right) {
        char *ax;

        ax = ptr;

        int size = strlen(ptr)+strlen(right.ptr)+2;
        ptr = new char[size];

        strcpy(ptr,ax);
        strcat(ptr,right.ptr);    
        delete [] ax;
    }
    void operator=(const string &right) {
        delete [] ptr;
        if (right.ptr != NULL) {
            ptr = new char[strlen(right.ptr)+1];
            strcpy(ptr,right.ptr);
        }
        else ptr = right.ptr;
    }
    operator==(const string &right) {
      return
        strcmp(ptr,right.ptr) != 0 ? 0 : 1;
    }
    operator!=(const string &right) {
      return
        strcmp(ptr,right.ptr) != 0 ? 1 : 0;
    }
    string(const string &right) {
        ptr = new char[strlen(right.ptr)+1];
        strcpy(ptr,right.ptr);
    }
    int len() {
        return(strlen(ptr));
    }
    char &operator[](int i) {
        return(ptr[i]);
    }
friend ostream &operator<<(ostream &s, string &st) ;
};

#endif // _STRING_DOT_HH_

// $Log: string.hh,v $
//Revision 1.2  1996/01/02  16:22:09  aml
//Formula compilation, evaluation and decompilation now work.
//Cells can be of type label, numerical formula or numbers.
//
//Revision 1.1  1995/12/30  14:53:29  aml
//Initial revision
//
//Revision 1.2  1994/09/10  16:04:16  aml
//Made changes to compile on hp.
//
//Revision 1.1  94/09/08  00:01:34  00:01:34  aml
//Initial revision
//
