// Managed_Types.cpp,v 1.7 2003/10/28 18:29:18 bala Exp

#include "tao/Managed_Types.h"

#if !defined (__ACE_INLINE__)
#include "tao/Managed_Types.i"
#endif /* __ACE_INLINE__ */

ACE_RCSID (tao,
           Managed_Types,
           "Managed_Types.cpp,v 1.7 2003/10/28 18:29:18 bala Exp")

// assignment from CORBA::String_var makes a copy
TAO_String_Manager&
TAO_String_Manager::operator= (const CORBA::String_var &var)
{
  CORBA::string_free (this->ptr_);
  this->ptr_ = CORBA::string_dup (var.in ());
  return *this;
}

// assignment from String_var
TAO_SeqElem_String_Manager&
TAO_SeqElem_String_Manager::operator= (const CORBA::String_var &var)
{
  if (this->release_)
    {
      CORBA::string_free (*this->ptr_);
    }

  *this->ptr_ = CORBA::string_dup (var.in ());
  return *this;
}

// ****************************************************************

// assignment from CORBA::WString_var makes a copy
TAO_WString_Manager&
TAO_WString_Manager::operator= (const CORBA::WString_var &var)
{
  CORBA::wstring_free (this->ptr_);
  this->ptr_ = CORBA::wstring_dup (var.in ());
  return *this;
}

// assignment from WString_var
TAO_SeqElem_WString_Manager&
TAO_SeqElem_WString_Manager::operator= (const CORBA::WString_var &var)
{
  if (this->release_)
    {
      CORBA::wstring_free (*this->ptr_);
    }

  *this->ptr_ = CORBA::wstring_dup (var.in ());
  return *this;
}
