// This may look like C, but it's really -*- C++ -*-

//=============================================================================
/**
 *  @file    UB_String_SArgument_T.h
 *
 *  UB_String_SArgument_T.h,v 1.2 2003/10/28 18:29:21 bala Exp
 *
 *  @authors Jeff Parsons and Carlos O'Ryan
 */
//=============================================================================

#ifndef TAO_UB_STRING_SARGUMENT_T_H
#define TAO_UB_STRING_SARGUMENT_T_H

#include /**/ "ace/pre.h"
#include "tao/Argument.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

namespace TAO
{
  /**
   * @class In_UB_String_SArgument_T
   *
   * @brief Template class for IN skeleton UB (w)string argument.
   *
   */
  template<typename S, typename S_var>
  class In_UB_String_SArgument_T : public Argument
  {
  public:
    In_UB_String_SArgument_T (void);

    virtual CORBA::Boolean demarshal (TAO_InputCDR &);

    virtual void interceptor_param (Dynamic::Parameter &);

    const S * arg (void) const;

  private:
    S_var x_;
  };

  /**
   * @class Inout_UB_String_SArgument_T
   *
   * @brief Template class for INOUT skeleton UB (w)string argument.
   *
   */
  template<typename S, typename S_var>
  class Inout_UB_String_SArgument_T : public Argument
  {
  public:
    Inout_UB_String_SArgument_T (void);

    virtual CORBA::Boolean marshal (TAO_OutputCDR &);
    virtual CORBA::Boolean demarshal (TAO_InputCDR &);

    virtual void interceptor_param (Dynamic::Parameter &);

    S *& arg (void);

  private:
    S_var x_;
  };

  /**
   * @class Out_UB_String_SArgument_T
   *
   * @brief Template class for INOUT skeleton UB (w)string argument.
   *
   */
  template<typename S, typename S_var>
  class Out_UB_String_SArgument_T : public Argument
  {
  public:
    Out_UB_String_SArgument_T (void);

    virtual CORBA::Boolean marshal (TAO_OutputCDR &);

    virtual void interceptor_param (Dynamic::Parameter &);

    S *& arg (void);

  private:
    S_var x_;
  };

  /**
   * @class Ret_UB_String_SArgument_T
   *
   * @brief Template class for return skeleton value of UB (w)string.
   *
   */
  template<typename S, typename S_var>
  class Ret_UB_String_SArgument_T : public Argument
  {
  public:
    Ret_UB_String_SArgument_T (void);

    virtual CORBA::Boolean marshal (TAO_OutputCDR &);

    virtual void interceptor_result (CORBA::Any *);

    S *& arg (void);

  private:
    S_var x_;
  };

  /**
   * @struct UB_String_SArg_Traits_T
   *
   * @brief Template class for argument traits of unbounded (w)strings.
   *
   */
  template<typename T, typename T_var, typename T_out>
  struct UB_String_SArg_Traits_T
  {
    typedef T *                                         ret_type;
    typedef const T *                                   in_type;
    typedef T *&                                        inout_type;
    typedef T_out                                       out_type;

    typedef In_UB_String_SArgument_T<T,T_var>           in_arg_val;
    typedef Inout_UB_String_SArgument_T<T,T_var>        inout_arg_val;
    typedef Out_UB_String_SArgument_T<T,T_var>          out_arg_val;
    typedef Ret_UB_String_SArgument_T<T,T_var>          ret_val;
  };
};

#if defined (__ACE_INLINE__)
#include "tao/UB_String_SArgument_T.inl"
#endif /* __ACE_INLINE__ */

#if defined (ACE_TEMPLATES_REQUIRE_SOURCE)
#include "tao/UB_String_SArgument_T.cpp"
#endif /* ACE_TEMPLATES_REQUIRE_SOURCE */

#if defined (ACE_TEMPLATES_REQUIRE_PRAGMA)
#pragma implementation ("UB_String_SArgument_T.cpp")
#endif /* ACE_TEMPLATES_REQUIRE_PRAGMA */

#include /**/ "ace/post.h"

#endif /* TAO_UB_STRING_SARGUMENT_T_H */
