/* -*- C++ -*- */
// Search_Struct.h,v 1.4 1998/10/20 02:34:40 levine Exp

// ============================================================================
//
// = LIBRARY
//    drwho
//
// = FILENAME
//    Search_Struct.h
//
// = AUTHOR
//    Douglas C. Schmidt
//
// ============================================================================

#ifndef _SEARCH_STRUCT_H
#define _SEARCH_STRUCT_H

#include "Protocol_Record.h"

class Search_Struct
{
  // = TITLE
  //   Provides an "Abstract Base Class" lookup table abstraction that
  //   stores and manipulates friend records.
public:
  Search_Struct (void);
  virtual ~Search_Struct (void);
  virtual int n_elems (void);

  virtual Protocol_Record *insert (const char *key_name,
                                   int max_len = MAXUSERIDNAMELEN) = 0;
  virtual Protocol_Record *get_next_entry (void) = 0;
  virtual Protocol_Record *get_each_entry (void) = 0;

protected:
  int count_;
};

#endif /* _SEARCH_STRUCT_H */
