(in-package "ACL2")

(include-book "add")
(include-book "../../../ordinals/e0-ordinal")
(set-well-founded-relation e0-ord-<)

(defun add3-measure (x y z)
  (acl2-count (+ x y z)))

(defthm add3-1
    (implies (and (integerp x)
		  (> x 0))
	     (and (>= (fl (/ x 2)) 0)
		  (< (fl (/ x 2)) x)))
  :rule-classes ())

(defthm recursion-by-add3-measure
    (IMPLIES (AND (INTEGERP X)
		  (<= 0 X)
		  (INTEGERP Y)
		  (<= 0 Y)
		  (INTEGERP Z)
		  (<= 0 Z)
		  (NOT (AND (EQUAL X 0)
			    (EQUAL Y 0)
			    (EQUAL Z 0))))
	     (e0-ord-< (ADD3-MEASURE (FL (* 1/2 x))
				     (FL (* 1/2 y))
				     (FL (* 1/2 z)))
		       (ADD3-MEASURE X Y Z)))
  :hints (("Goal" :use ((:instance add3-1)
			(:instance add3-1 (x y))
			(:instance add3-1 (x z))))))

(in-theory (disable add3-measure))

(defun add3-induct (x y z)
  (declare (xargs :measure (add3-measure x y z)))
  (if (and (integerp x) (>= x 0)
	   (integerp y) (>= y 0)
	   (integerp z) (>= z 0))
      (if (and (= x 0) (= y 0) (= z 0))
	  ()
	(add3-induct (fl (/ x 2)) (fl (/ y 2)) (fl (/ z 2))))
    ()))

(in-theory (disable logand logior logxor))

(defthm add3-2
    (implies (and (INTEGERP X)
		  (<= 0 X)
		  (INTEGERP Y)
		  (<= 0 Y)
		  (INTEGERP Z)
		  (<= 0 Z))
	     (= (LOGXOR (FL (* X 1/2))
			(LOGXOR (FL (* Y 1/2)) (FL (* Z 1/2))))
		(fl (/ (logxor x (logxor y z)) 2))))
  :rule-classes()
  :hints (("Goal" :use ((:instance logxor-fl (i y) (j z))
			(:instance logxor-nat (i y) (j z))
			(:instance logxor-fl (i x) (j (logxor y z)))))))

(defthm add3-3
    (implies (and (INTEGERP X)
		  (<= 0 X)
		  (INTEGERP Y)
		  (<= 0 Y)
		  (INTEGERP Z)
		  (<= 0 Z))
	     (= (LOGIOR (LOGAND (FL (* X 1/2)) (FL (* Y 1/2)))
			(LOGIOR (LOGAND (FL (* X 1/2)) (FL (* Z 1/2)))
				(LOGAND (FL (* Y 1/2)) (FL (* Z 1/2)))))
		(fl (/ (logior (logand x y)
			       (logior (logand x z) (logand y z)))
		       2))))
  :rule-classes()
  :hints (("Goal" :use ((:instance logand-fl)
			(:instance logand-fl (y z))
			(:instance logand-fl (x y) (y z))
			(:instance logand-nat (i x) (j y))
			(:instance logand-nat (i x) (j z))
			(:instance logand-nat (i y) (j z))
			(:instance logior-fl (i (logand x z)) (j (logand y z)))
			(:instance logior-nat (i (logand x z)) (j (logand y z)))
			(:instance logior-fl (i (logand x y)) (j (logior (logand x z) (logand y z))))))))

(defthm add3-4
    (IMPLIES (AND (INTEGERP X)
		  (<= 0 X)
		  (INTEGERP Y)
		  (<= 0 Y)
		  (INTEGERP Z)
		  (<= 0 Z)
		  (NOT (AND (= X 0) (= Y 0) (= Z 0)))
		  (IMPLIES (AND (INTEGERP (FL (* X 1/2)))
				(<= 0 (FL (* X 1/2)))
				(INTEGERP (FL (* Y 1/2)))
				(<= 0 (FL (* Y 1/2)))
				(INTEGERP (FL (* Z 1/2)))
				(<= 0 (FL (* Z 1/2))))
			   (= (+ (FL (* X 1/2))
				 (FL (* Y 1/2))
				 (FL (* Z 1/2)))
			      (+ (LOGXOR (FL (* X 1/2))
					 (LOGXOR (FL (* Y 1/2)) (FL (* Z 1/2))))
				 (* 2
				    (LOGIOR (LOGAND (FL (* X 1/2)) (FL (* Y 1/2)))
					    (LOGIOR (LOGAND (FL (* X 1/2)) (FL (* Z 1/2)))
						    (LOGAND (FL (* Y 1/2))
							    (FL (* Z 1/2))))))))))
	     (= (+ (fl (/ x 2)) (fl (/ y 2)) (fl (/ z 2)))
		(+ (fl (/ (logxor x (logxor y z)) 2))
		   (* 2 (fl (/ (logior (logand x y) (logior (logand x z) (logand y z))) 2))))))
  :rule-classes ()
  :hints (("Goal" :use (add3-2 add3-3))))

(defthm add3-5
    (IMPLIES (AND (INTEGERP X)
		  (<= 0 X)
		  (INTEGERP Y)
		  (<= 0 Y)
		  (INTEGERP Z)
		  (<= 0 Z))
	     (= (fl (/ (+ (bitn x 0) (bitn y 0) (bitn z 0)) 2))
		(bitn (logior (logand x y) (logior (logand x z) (logand y z))) 0)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bitn-0-1 (n 0))
			(:instance bitn-0-1 (n 0) (x y))
			(:instance bitn-0-1 (n 0) (x z))
			(:instance bitn-0-1 (n 0))
			(:instance bit-dist-a (n 0))
			(:instance bit-dist-a (n 0) (y z))
			(:instance bit-dist-a (n 0) (x y) (y z))
			(:instance bit-dist-b (n 0) (x (logand x z)) (y (logand y z)))
			(:instance bit-dist-b (n 0) (x (logand x y)) (y (logior (logand x z) (logand y z))))
			(:instance logand-nat (i x) (j y))
			(:instance logand-nat (i x) (j z))
			(:instance logand-nat (i y) (j z))
			(:instance logior-nat (i (logand x z)) (j (logand y z)))))))

(local (defthm bitn-rewrite
    (implies (and (integerp x)
		  (integerp k)
		  (>= x 0)
		  (>= k 0))
	     (equal (bitn x k)
		    (rem (fl (/ x (expt 2 k)))
			 2)))
    :hints (("Goal" :use (bitn-def)))))

(local (in-theory (disable bitn-rewrite)))

(defthm BITN-0-LOGXOR-+
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp b)
		  (>= b 0))
	     (= (bitn (+ a b) 0)
		(bitn (logxor a b) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bitn-rewrite)
		  :use ((:instance rem012 (x a))
			(:instance rem012 (x b))
			(:instance bitn-logxor (x a) (y b) (n 0))
			(:instance rem+rem (n 2))
			(:instance rem+rem (n 2) (a (rem b 2)) (b a))))))

(defthm add3-6
    (IMPLIES (AND (INTEGERP X)
		  (<= 0 X)
		  (INTEGERP Y)
		  (<= 0 Y)
		  (INTEGERP Z)
		  (<= 0 Z))
	     (= (bitn (+ x y z) 0)
		(bitn (logxor x (logxor y z)) 0)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bitn-0-logxor-+ (a x) (b (+ y z)))
			(:instance bitn-0-logxor-+ (a y) (b z))
			(:instance bitn-logxor (n 0) (y (+ y z)))
			(:instance bitn-logxor (n 0) (y (logxor y z)))
			(:instance logxor-nat (i y) (j z))))))

(defthm add3-7
    (IMPLIES (AND (INTEGERP X)
		  (<= 0 X)
		  (INTEGERP Y)
		  (<= 0 Y)
		  (INTEGERP Z)
		  (<= 0 Z))
	     (= (fl (/ (+ x y z) 2))
		(fl (+ (fl (/ x 2)) (fl (/ y 2)) (fl (/ z 2)) (/ (+ (bitn x 0) (bitn y 0) (bitn z 0)) 2)))))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bitn-rewrite)
		  :use ((:instance rem-fl (n 2) (m x))
			(:instance rem-fl (n 2) (m y))
			(:instance rem-fl (n 2) (m z))))))

(defthm add3-8
    (IMPLIES (AND (INTEGERP X)
		  (<= 0 X)
		  (INTEGERP Y)
		  (<= 0 Y)
		  (INTEGERP Z)
		  (<= 0 Z))
	     (= (fl (/ (+ x y z) 2))
		(+ (fl (/ x 2)) (fl (/ y 2)) (fl (/ z 2))
		   (fl (/ (+ (bitn x 0) (bitn y 0) (bitn z 0)) 2)))))
  :rule-classes ()
  :hints (("Goal" :use (add3-7
			(:instance fl+int-rewrite
				   (x (/ (+ (bitn x 0) (bitn y 0) (bitn z 0)) 2))
				   (n (+ (fl (/ x 2)) (fl (/ y 2)) (fl (/ z 2)))))))))

(defthm add3-9
    (IMPLIES (AND (INTEGERP X)
		  (<= 0 X)
		  (INTEGERP Y)
		  (<= 0 Y)
		  (INTEGERP Z)
		  (<= 0 Z)
		  (NOT (AND (= X 0) (= Y 0) (= Z 0)))
		  (IMPLIES (AND (INTEGERP (FL (* X 1/2)))
				(<= 0 (FL (* X 1/2)))
				(INTEGERP (FL (* Y 1/2)))
				(<= 0 (FL (* Y 1/2)))
				(INTEGERP (FL (* Z 1/2)))
				(<= 0 (FL (* Z 1/2))))
			   (= (+ (FL (* X 1/2))
				 (FL (* Y 1/2))
				 (FL (* Z 1/2)))
			      (+ (LOGXOR (FL (* X 1/2))
					 (LOGXOR (FL (* Y 1/2)) (FL (* Z 1/2))))
				 (* 2
				    (LOGIOR (LOGAND (FL (* X 1/2)) (FL (* Y 1/2)))
					    (LOGIOR (LOGAND (FL (* X 1/2)) (FL (* Z 1/2)))
						    (LOGAND (FL (* Y 1/2))
							    (FL (* Z 1/2))))))))))
	     (= (fl (/ (+ x y z) 2))
		(+ (fl (/ (logxor x (logxor y z)) 2))
		   (* 2 (fl (/ (logior (logand x y) (logior (logand x z) (logand y z))) 2)))
		   (bitn (logior (logand x y) (logior (logand x z) (logand y z))) 0))))
  :rule-classes ()
  :hints (("Goal" :use (add3-4 add3-5 add3-8))))

(defthm add3-10
    (IMPLIES (AND (INTEGERP X)
		  (<= 0 X)
		  (INTEGERP Y)
		  (<= 0 Y)
		  (INTEGERP Z)
		  (<= 0 Z)
		  (NOT (AND (= X 0) (= Y 0) (= Z 0)))
		  (IMPLIES (AND (INTEGERP (FL (* X 1/2)))
				(<= 0 (FL (* X 1/2)))
				(INTEGERP (FL (* Y 1/2)))
				(<= 0 (FL (* Y 1/2)))
				(INTEGERP (FL (* Z 1/2)))
				(<= 0 (FL (* Z 1/2))))
			   (= (+ (FL (* X 1/2))
				 (FL (* Y 1/2))
				 (FL (* Z 1/2)))
			      (+ (LOGXOR (FL (* X 1/2))
					 (LOGXOR (FL (* Y 1/2)) (FL (* Z 1/2))))
				 (* 2
				    (LOGIOR (LOGAND (FL (* X 1/2)) (FL (* Y 1/2)))
					    (LOGIOR (LOGAND (FL (* X 1/2)) (FL (* Z 1/2)))
						    (LOGAND (FL (* Y 1/2))
							    (FL (* Z 1/2))))))))))
	     (= (fl (/ (+ x y z) 2))
		(+ (fl (/ (logxor x (logxor y z)) 2))
		   (logior (logand x y) (logior (logand x z) (logand y z))))))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bitn-rewrite)
		  :use (add3-9
			(:instance rem-fl
				   (m (logior (logand x y) (logior (logand x z) (logand y z))))
				   (n 2))
			(:instance logand-nat (i x) (j y))
			(:instance logand-nat (i x) (j z))
			(:instance logand-nat (i y) (j z))
			(:instance logior-nat (i (logand x z)) (j (logand y z)))
			(:instance logior-nat (i (logand x y)) (j (logior (logand x z) (logand y z))))))))

(defthm add3-11
    (IMPLIES (AND (INTEGERP X)
		  (<= 0 X)
		  (INTEGERP Y)
		  (<= 0 Y)
		  (INTEGERP Z)
		  (<= 0 Z)
		  (NOT (AND (= X 0) (= Y 0) (= Z 0)))
		  (IMPLIES (AND (INTEGERP (FL (* X 1/2)))
				(<= 0 (FL (* X 1/2)))
				(INTEGERP (FL (* Y 1/2)))
				(<= 0 (FL (* Y 1/2)))
				(INTEGERP (FL (* Z 1/2)))
				(<= 0 (FL (* Z 1/2))))
			   (= (+ (FL (* X 1/2))
				 (FL (* Y 1/2))
				 (FL (* Z 1/2)))
			      (+ (LOGXOR (FL (* X 1/2))
					 (LOGXOR (FL (* Y 1/2)) (FL (* Z 1/2))))
				 (* 2
				    (LOGIOR (LOGAND (FL (* X 1/2)) (FL (* Y 1/2)))
					    (LOGIOR (LOGAND (FL (* X 1/2)) (FL (* Z 1/2)))
						    (LOGAND (FL (* Y 1/2))
							    (FL (* Z 1/2))))))))))
	     (= (+ X Y Z)
		(+ (LOGXOR X (LOGXOR Y Z))
		   (* 2
		      (LOGIOR (LOGAND X Y)
			      (LOGIOR (LOGAND X Z)
				      (LOGAND Y Z)))))))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bitn-rewrite)
		  :use (add3-10
			add3-6
			(:instance rem-fl (n 2) (m (+ x y z)))
			(:instance logxor-nat (i x) (j (logxor y z)))
			(:instance logxor-nat (i y) (j z))
			(:instance rem-fl (n 2) (m (logxor x (logxor y z))))))))

(defthm ADD3
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp y)
		  (>= y 0)
		  (integerp z)
		  (>= z 0))
	     (= (+ x y z)
		(+ (logxor x (logxor y z))
		   (* 2 (logior (logand x y)
				(logior (logand x z)
					(logand y z)))))))
  :rule-classes ()
  :hints (("Goal" :induct (add3-induct x y z))
	  ("Subgoal *1/2" :use (add3-11))))
