(in-package "ACL2")

(include-book "floor")


(defthm fl-rem-0
    (implies (and (integerp m) (>= m 0)
		  (integerp n) (> n 0))
	     (iff (= (rem m n) 0)
		  (= m (* (fl (/ m n)) n))))
  :rule-classes ()
  :hints (("goal" :use (rem-fl))))

(defthm fl-rem-1
    (implies (and (integerp m) (>= m 0)
		  (integerp n) (> n 0))
	     (>= m (* (fl (/ m n)) n)))
  :rule-classes ()
  :hints (("goal" :use (rem-fl rem>=0))))

(local
(defthm fl-rem-2
    (implies (and (integerp m) (>= m 0)
		  (integerp n) (> n 0)
		  (integerp p) (> p 0))
	     (= (* (fl (/ m (* n p)))
		   (* n p))
		(* (* (fl (/ (fl (/ m n)) p))
		      p)
		   n)))
  :rule-classes ()
  :hints (("goal" :use ((:instance fl/int-rewrite (x (/ m n)) (n p)))))))

(local
(defthm fl-rem-3
    (implies (and (integerp m) (>= m 0)
		  (integerp n) (> n 0)
		  (integerp p) (> p 0))
	     (<= (* (fl (/ m (* n p)))
		    (* n p))
		 (* (fl (/ m n)) n)))
  :rule-classes ()
  :hints (("goal" :use (fl-rem-2
			(:instance fl-rem-1 (m (fl (/ m n))) (n p)))))))

(local
(defthm fl-rem-4
    (implies (and (integerp m) (>= m 0)
		  (integerp n) (> n 0)
		  (integerp p) (> p 0))
	     (iff (= (* (fl (/ m (* n p)))
			(* n p))
		     m)
		  (and (= (* (fl (/ (fl (/ m n)) p)) p)
			  (fl (/ m n)))
		       (= (* (fl (/ m n)) n)
			  m))))
  :rule-classes ()
  :hints (("goal" :use (fl-rem-2 fl-rem-3 fl-rem-1)))))

(defthm fl-rem-5
    (implies (and (integerp m) (>= m 0)
		  (integerp n) (> n 0)
		  (integerp p) (> p 0))
	     (iff (= (rem m (* n p)) 0)
		  (and (= (rem m n) 0)
		       (= (rem (fl (/ m n)) p) 0))))
  :rule-classes ()
  :hints (("goal" :use (fl-rem-4 
			fl-rem-0
			(:instance fl-rem-0 (n (* n p)))
			(:instance fl-rem-0 (m (fl (/ m n))) (n p))))))


(local (defthm hack6
    (implies (and (rationalp a)
		  (rationalp b)
		  (rationalp c)
		  (rationalp ap)
		  (rationalp k)
		  (= (+ a b) c)
		  (= (+ ap (* k b)) (* k c)))
	     (= ap (* k a)))
    :rule-classes ()))

(defthm rem**
    (implies (and (integerp m)
		  (>= m 0)
		  (integerp n)
		  (> n 0)
                  (integerp (* n k)) ;new
                  (integerp (* m k)) ;new
                  (rationalp k) ;new
		;  (integerp k) ;removed
		  (> k 0))
	     (= (rem (* k m) (* k n))
		(* k (rem m n))))
  :rule-classes ()
  :hints (("goal"
           :use (rem-fl
                 (:instance hack6 
                            (a (rem m n)) (b (* n (fl (/ m n)))) (c m) (ap (rem (* k m) (* k n))))
                 (:instance rem-fl (m (* k m)) (n (* k n)))))))
(local
 (defthm rem-rem-1
   (implies (and (integerp x)
                 (>= x 0)
                 (integerp b)
                 (> b 0)
                 (integerp a)
                 (>= a b))
            (>= (* (FL (* X (/ (EXPT 2 A))))
                   (EXPT 2 (+ A (* -1 B))))
                0))
   :rule-classes ()
   :hints (("Goal" :in-theory (disable expt-pos)
            :use ((:instance expt-pos (x (- a b)))
                  (:instance expt-pos (x a))
                  (:instance n<=fl-linear (n 0) (x (* X (/ (EXPT 2 A))))))))))

(defthm REM-REM
  (implies (and (integerp x)
                (>= x 0)
                (integerp b)
                (> b 0)
                (integerp a)
                (>= a b))
           (= (rem x (expt 2 b))
              (rem (rem x (expt 2 a)) (expt 2 b))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable integerp-expt-type)
           :use ((:instance rem-fl (m x) (n (expt 2 a)))
			(:instance expo+ (m b) (n (- a b)))
			(:instance rem-rem-1)
			(:instance rem>=0 (m x) (n (expt 2 a)))
			(:instance integerp-expt-type (n (- a b)))			
			(:instance rem+ 
				   (m (rem x (expt 2 a)))
				   (n (expt 2 b)) 
				   (a (* (expt 2 (- a b)) (fl (/ x (expt 2 a))))))))))


(local-defthm rem-minus-rem-1
    (implies (and (integerp a)
		  (integerp b)
		  (integerp n)
		  (>= a b)
		  (>= b 0)
		  (> n 0))
	     (= (- a (rem b n))
		(+ (- a b) (* n (fl (/ b n))))))
  :rule-classes ()
  :hints (("goal" :use ((:instance rem-fl (m b))))))

(local-defthm hack16
    (implies (= x y)
	     (= (rem x n) (rem y n)))
  :rule-classes ())

(local-defthm rem-minus-rem-2
    (implies (and (integerp a)
		  (integerp b)
		  (integerp n)
		  (>= a b)
		  (>= b 0)
		  (> n 0))
	     (= (rem (- a (rem b n)) n)
		(rem (+ (- a b) (* n (fl (/ b n)))) n)))
  :rule-classes ()
  :hints (("goal" :use (rem-minus-rem-1
			(:instance hack16 (x (- a (rem b n))) (y (+ (- a b) (* n (fl (/ b n))))))))))

(defthm rem-minus-rem
    (implies (and (integerp a)
		  (integerp b)
		  (integerp n)
		  (>= a b)
		  (>= b 0)
		  (> n 0))
	     (= (rem (- a (rem b n)) n)
		(rem (- a b) n)))
  :rule-classes ()
  :hints (("goal" :use (rem-minus-rem-2
			(:instance rem+ (m (- a b)) (a (fl (/ b n))))))))

(defthm REM012
  (implies (and (integerp x)
                (>= x 0))
           (or (= (rem x 2) 0)
               (= (rem x 2) 1)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance rem<n (m x) (n 2))
			(:instance rem>=0 (m x) (n 2))))))


(defthm bit+-3
  (implies (and (integerp x) (> x 0))
           (>= (* x 2) 2))
  :rule-classes ())

;not needed past bits
(defthm bit+-4
   (implies (integerp x)
            (not (= (* x 2) 1)))
   :rule-classes ()
   :hints (("Goal" :use ((:instance bit+-3)
                         (:instance bit+-3 (x (- x)))))))

(defthm REM+1-2
  (implies (and (integerp x)
                (>= x 0))
           (not (= (rem x 2) (rem (1+ x) 2))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance rem-fl (m x) (n 2))
			(:instance bit+-4 (x (- (fl (/ (1+ x) 2)) (fl (/ x 2)))))
			(:instance rem-fl (m (1+ x)) (n 2))))))

(defthm rem<=m
    (implies (and (integerp m) (>= m 0)
		  (integerp n) (> n 0))
	     (<= (rem m n) m))
  :rule-classes ()
  :hints (("goal" :use ((:instance rem-fl)
			(:instance n<=fl-linear (n 0) (x (/ m n)))))))

(defthm rem+rem
    (implies (and (integerp a)
		  (integerp b)
		  (integerp n)
		  (>= a 0)
		  (>= b 0)
		  (> n 0))
	     (= (rem (+ a (rem b n)) n)
		(rem (+ a b) n)))
  :rule-classes ()
  :hints (("goal" :use ((:instance rem-fl (m b))
			(:instance rem>=0 (m b))
			(:instance rem+ (m (+ a (rem b n))) (a (fl (/ b
                                                                      n))))))))

(defthm rem-x-y-x-2
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp y)
		  (>= y 0))
	     (iff (= (rem (+ x y) 2) (rem x 2))
		  (= (rem y 2) 0)))
  :rule-classes ()
  :hints (("goal" :use ((:instance rem012 (x y))
			(:instance rem+rem (a x) (b y) (n 2))
			(:instance rem+1-2)))))


(defthm rem-m=n
    (implies (and (integerp m)
		  (> m 0)
		  (integerp n)
		  (> n 0)
		  (< m (* 2 n))
		  (= (rem m n) 0))
	     (= m n))
  :rule-classes ()
  :hints (("goal" :use ((:instance rem<)
			(:instance rem< (m (- m n)))
			(:instance rem+ (m (- m n)) (a 1))))))


(defthm rem-0
  (implies (natp m)
           (equal (rem m 0) m))
  :hints (("Goal" :expand (rem m 0))))

(defthm rationalp-rem
    (implies (and (rationalp m)
		  (rationalp n))
	     (rationalp (rem m n)))
  :rule-classes :type-prescription)

(defthm rationalp-rem-rewrite
    (implies (and (rationalp m)
		  (rationalp n))
	     (rationalp (rem m n))))

(defthm integerp-rem
    (implies (and (integerp m)
		  (integerp n))
	     (integerp (rem m n)))
  :rule-classes :type-prescription)

(defthm integerp-rem-rewrite
    (implies (and (integerp m)
		  (integerp n))
	     (integerp (rem m n))))

(defthm natp-rem
  (implies (and (natp m)
                (natp n))
           (natp (rem m n)))
  :rule-classes :type-prescription
  :hints (("Goal" :use rem>=0)))

(defthm natp-rem-rewrite
  (implies (and (natp m)
                (natp n))
           (natp (rem m n))))

(defthm rem-bnd-1
    (implies (and (natp m)
		  (natp n)
		  (not (= n 0)))
	     (< (rem m n) n))
  :rule-classes :linear
  :hints (("Goal" :use rem<n)))

(defthm rem-bnd-2
    (implies (and (natp m)
		  (natp n))
	     (<= (rem m n) m))
  :rule-classes :linear
  :hints (("Goal" :use rem<=m)))

(defthm quot-rem
    (implies (and (natp m)
		  (natp n))
	     (equal (+ (* n (fl (/ m n))) (rem m n))
		    m))
  :rule-classes ()
  :hints (("Goal" :use rem-fl)))

(defthm rem-mult
    (implies (and (natp m)
		  (natp a)
		  (natp n))
	     (equal (rem (+ m (* a n)) n)
		    (rem m n)))
  :hints (("Goal" :use rem+)))

(in-theory (disable rem-mult))

(defthm rem-sum
    (implies (and (natp a)
		  (natp b)
		  (natp n))
	     (equal (rem (+ a (rem b n)) n)
		    (rem (+ a b) n)))
  :hints (("Goal" :use rem+rem)))

(in-theory (disable rem-sum))

(defthm rem-diff
    (implies (and (natp a)
		  (natp b)
		  (natp n)
		  (>= a b))
	     (equal (rem (- a (rem b n)) n)
		    (rem (- a b) n)))
  :hints (("Goal" :use rem-minus-rem)))

(in-theory (disable rem-diff))

(defthm rem-equal
    (implies (and (natp m)
		  (natp n)
		  (< m n))
	     (equal (rem m n) m))
  :hints (("Goal" :use (rem<))))

(defthm rem-1
  (implies (natp x)
           (equal (rem x 1) 0))
  :hints (("Goal"
           :use
           ((:instance rem-bnd-1
                       (m x) (n 1))))))

(defthm rem-of-rem
    (implies (and (natp x)
		  (natp a)
		  (natp b)
		  (>= a b))
	     (equal (rem (rem x (expt 2 a)) (expt 2 b))
		    (rem x (expt 2 b))))
  :hints (("Goal" :use (rem-rem))))

(in-theory (disable rem-of-rem))

(defthm rem-must-be-n
    (implies (and (natp m)
		  (natp n)
		  (not (= m 0))
		  (< m (* 2 n))
		  (= (rem m n) 0))
	     (= m n))
  :rule-classes ()
  :hints (("Goal" :use (rem-m=n))))

(defthm rem-prod
    (implies (and (natp m)
		  (natp n)
                  (integerp (* n k)) ;new
                  (integerp (* m k)) ;new
                  (rationalp k)      ;new
                  (> k 0)            ;new
		  (not (= n 0)))
	     (equal (rem (* k m) (* k n))
		    (* k (rem m n))))
  :hints (("goal" :use (rem**))))

(in-theory (disable rem-prod))

#| less general version:
(defthm rem-prod
    (implies (and (natp m)
		  (natp n)
		  (natp k)
		  (not (= n 0)))
	     (equal (rem (* k m) (* k n))
		    (* k (rem m n))))
  :hints (("Goal" :use (rem**))))
|#

(defthm rem-squeeze
    (implies (and (integerp m) (>= m 0)
		  (integerp n) (> n 0)
		  (integerp a) (>= a 0)
		  (integerp r) (>= r 0)
		  (<= (* a n) m)
		  (< m (+ (* a n) r)))
	     (< (rem m n) r))
  :rule-classes ()
  :hints (("goal" :use ((:instance rem-fl)
			(:instance n<=fl-linear (x (/ m n)) (n a))))))

(defthm rem-squeeze-2
    (implies (and (integerp m)
		  (>= m 0)
		  (integerp n)
		  (> n 0)
		  (integerp a)
		  (>= a 0)
		  (> (* (1+ a) n) m)
		  (>= m (* a n)))
	     (= (rem m n) (- m (* a n))))
  :rule-classes nil :hints
  (("goal" :use
	   ((:instance rem-fl)
	    (:instance fl-unique (x (/ m n)) (n a))))))


(defthm rem-bnd-3
    (implies (and (natp m)
		  (natp n)
		  (natp a)
		  (natp r)
		  (<= (* a n) m)
		  (< m (+ (* a n) r)))
	     (< (rem m n) r))
  ;; Free variables make this rule very weak, but it seems harmless
  ;; enough to make it a :linear rule.
  :rule-classes :linear
  :hints (("Goal" :use (rem-squeeze))))

(defthm rem-force
    (implies (and (natp m)
		  (natp n)
		  (natp a)
		  (> (* (1+ a) n) m)
		  (>= m (* a n)))
	     (= (rem m n) (- m (* a n))))
  :rule-classes ()
  :hints (("Goal" :use (rem-squeeze-2))))

;from divsqrt:

(local
(defthm rem=rem-1
    (implies (and (integerp a) (>= a 0)
		  (integerp b) (>= b 0)
		  (integerp n) (> n 0)
		  (= (rem a n) (rem b n)))
	     (= (- a (* n (fl (/ a n))))
		(- b (* n (fl (/ b n))))))
  :rule-classes ()
  :hints (("goal" :use ((:instance rem-fl (m a))
			(:instance rem-fl (m b)))))))

(local
(defthm rem=rem-2
    (implies (and (integerp a) (>= a 0)
		  (integerp b) (>= b 0)
		  (integerp n) (> n 0)
		  (= (rem a n) (rem b n)))
	     (= (- a b) (* n (- (fl (/ a n)) (fl (/ b n))))))
  :rule-classes ()
  :hints (("goal" :use ((:instance rem=rem-1))))))

(local
(defthm hack-m10
    (implies (and (rationalp a) (rationalp b) (rationalp c) (> b 0) (= a (* b c)))
	     (= (/ a b) c))
  :rule-classes ()))

(local
(defthm rem=rem-3
    (implies (and (integerp a) (>= a 0)
		  (integerp b) (>= b 0)
		  (integerp n) (> n 0)
		  (= (rem a n) (rem b n)))
	     (= (/ (- a b) n) (- (fl (/ a n)) (fl (/ b n)))))
  :rule-classes ()
  :hints (("goal" :use ((:instance rem=rem-2)
			(:instance hack-m10 (a (- a b)) (b n) (c (- (fl (/ a n)) (fl (/ b n))))))))))

(defthm rem=rem
    (implies (and (integerp a) (>= a 0)
		  (integerp b) (>= b 0)
		  (integerp n) (> n 0)
		  (= (rem a n) (rem b n)))
	     (integerp (/ (- a b) n)))
  :rule-classes ()
  :hints (("goal" :use ((:instance rem=rem-3)))))


(defthm rem-equal-int
    (implies (and (natp a)
		  (natp b)
		  (natp n)
		  (= (rem a n) (rem b n)))
	     (integerp (/ (- a b) n)))
  :rule-classes ()
  :hints (("Goal" :use (rem=rem))))

(defthm rem-0-fl
    (implies (and (natp m)
		  (natp n))
	     (iff (= (rem m n) 0)
		  (= m (* (fl (/ m n)) n))))
  :rule-classes ()
  :hints (("Goal" :use (fl-rem-0))))

(defthm quot-bnd
    (implies (and (natp m)
		  (natp n))
	     (>= m (* (fl (/ m n)) n)))
  :rule-classes :linear
  :hints (("Goal" :use (fl-rem-1))))

(defthm rem-0-0
    (implies (and (natp m)
		  (natp n)
		  (natp p)
                  (not (= p 0)))
	     (iff (= (rem m (* n p)) 0)
		  (and (= (rem m n) 0)
		       (= (rem (fl (/ m n)) p) 0))))
  :rule-classes ()
  :hints (("Goal" :use (fl-rem-5))))

(defthm divides-rem-0
    (implies (and (integerp n)
		  (integerp a)
		  (> n 0)
		  (>= a 0))
	     (= (rem (* a n) n)
		0))
  :rule-classes ()
  :hints (("goal" :use ((:instance rem+ (m 0))
			(:instance rem< (m 0))))))

(defthm rem-mult-2
    (implies (and (natp n)
		  (natp a))
	     (equal (rem (* a n) n)
		    0))
  :hints (("Goal" :use (divides-rem-0))))

(in-theory (disable rem-mult-2))