(in-package "ACL2")

;(include-book "include-book-macros")

(include-book "fp2")
(include-book "predicate")

;get more rules form arithmetic-2 ?




;;=================================================================================
;; Collect leading constants in comparisons.
;; This section is complete.
;;===================================================================================

(defthm collect-constants-in-equal-of-sums
  (implies (and (syntaxp (and (quotep c1) (quotep c2)))
                (case-split (acl2-numberp c1))
                )
           (and (equal (equal (+ c2 x) c1)
                       (equal (fix x) (- c1 c2)))
                (equal (equal c1 (+ c2 x))
                       (equal (fix x) (- c1 c2))))))

(defthm collect-constants-in-equal-of-sums-2
  (implies (syntaxp (and (quotep c1) (quotep c2)))
           (and (equal (equal (+ c2 x) (+ c1 y))
                       (equal (fix x) (+ (- c1 c2) y))))))

(defthm collect-constants-in-<-of-sums
  (implies (syntaxp (and (quotep c1) (quotep c2)))
           (and (equal (< (+ c2 x) c1)
                       (< x (- c1 c2)))
                (equal (< c1 (+ c2 x))
                       (< (- c1 c2) x)))))

(defthm collect-constants-in-<-of-sums-2
  (implies (syntaxp (and (quotep c1) (quotep c2)))
           (equal (< (+ c2 x) (+ c1 y))
                  (< x (+ (- c1 c2) y)))))






;replaced iff with equal




;mine is better
;(in-theory (disable a10))








;this book includes (how many?) main types of lemmas

;there's stuff in fraccoeff too


;collecting constants
; equal with sums
; < with sums
; < with products
; equal with products

;rearranging negative coeffs
;getting rid of fractional coeffs

;cancelling factors in comparisons of sums (these sums may each have only 1 addend)

;misc lemmas (comparing products to 0)



;(< (+ X Y (* A Y)) Y)

;expt thms?

;see equal-constant-+ in equalities.lisp















;see also see MULT-BOTH-SIDES-OF-EQUAL
(defthm mult-both-sides-of-<-by-positive
  (implies (and (<= 0 c)
                (rationalp c)
                (case-split (< 0 c))
                )
           (equal (< (* c a) (* c b))
                  (< a b))))

(in-theory (disable mult-both-sides-of-<-by-positive))

#|

(defthm mult-both-sides-of-<-neg
  (implies (and (rationalp a)
                (rationalp b)
                (rationalp c)
                (< c 0))
           (equal (< (* a c) (* b c))
                  (> a b)))
  )
|#

(include-book "../../../meta/meta-times-equal")
(include-book "../../../meta/meta-plus-equal")
(include-book "../../../meta/meta-plus-lessp")


(defthm mult-both-sides-of-equal
  (implies (and (case-split (acl2-numberp a))
                (case-split (acl2-numberp b))
                (case-split (acl2-numberp c))
                )
           (equal (equal (* a c) (* b c)) 
                  (if (equal c 0)
                      t
                    (equal a b))))
  :rule-classes nil
)



#|

;instead of these, we should just cancel common factors from the constants

;open question: how to handle (equal (* 2 x) (* 3 y)) -- should we collect the constants or not? 

;don't yet handle negative constants
;prefers the quotient of the constants to be > 1
;maybe the constant should be by itself?
(defthm collect-constants-in-product-<-1-of-2-with-1-of-2
  (implies (and (syntaxp (and (quotep c1) (quotep c2)))
                (rationalp c1)
                (rationalp c2)
                (< 0 c1) ;gen
                (< 0 c2) ;gen
                (rationalp a)
                (rationalp b))
           (equal (< (* c1 a) (* c2 b))
                  (if (> c1 c2)
                      (< (* (/ c1 c2) a) b)
                    (< a (* (/ c2 c1) b)))))
  :hints (("Goal" :use ((:instance mult-both-sides-of-<-by-positive 
                                   (a (* c1 a))
                                   (b (* c2 b))
                                   (c (/ c1)))
                        (:instance mult-both-sides-of-<-by-positive 
                                   (a (* c1 a))
                                   (b (* c2 b))
                                   (c (/ c2)))))))

(defthm collect-constants-in-product-<-1-of-1-with-1-of-2
  (implies (and (syntaxp (and (quotep c1) (quotep c2)))
                (rationalp c1)
                (rationalp c2)
                (< 0 c1) ;gen
                (< 0 c2) ;gen
                (rationalp b))
           (equal (< c1 (* c2 b))
                  (< (/ c1 c2) b)))
  :hints (("Goal" :use ((:instance mult-both-sides-of-<-by-positive 
                                   (a c1)
                                   (b (* c2 b))
                                   (c (/ c2)))))))

(defthm collect-constants-in-product-<-1-of-2-with-1-of-1
  (implies (and (syntaxp (and (quotep c1) (quotep c2)))
                (rationalp c1)
                (rationalp c2)
                (< 0 c1) ;gen
                (< 0 c2) ;gen
                (rationalp b))
           (equal (< (* c2 b) c1)
                  (< b (/ c1 c2))))
  :hints (("Goal" :use ((:instance mult-both-sides-of-<-by-positive 
                                   (b c1)
                                   (a (* c2 b))
                                   (c (/ c2)))))))



|#

#|



(defthm mult-both-sides-of-<
  (implies (and (rationalp a)
                (rationalp b)
                (rationalp c)
;                (not (equal c 0))
               (> c 0)
                )
           (implies (< a b)
                    (< (* a c) (* b c))))
  :rule-classes nil)

|#



;generalize to acl2-numberp whenever possible
;make more like these!

;drop?
;is this like rearrange-negative coeffs?
(defthm rearr-neg-eric
  (implies (and (rationalp a)
                (rationalp b)
                (rationalp c)
                (rationalp d))
           (equal (EQUAL (+ a (* -1 b) c)
                         d)
                  (equal (+ a c) (+ b d)))))


(defthm equal-zero-product
  (implies (and (case-split (acl2-numberp x))
                (case-split (acl2-numberp y))
                (case-split (not (equal 0 x)))
                )
           (equal (equal 0 (* x y))
                  (equal 0 y))))

(defthm equal-zero-product-2
  (implies (and (case-split (acl2-numberp x))
                (case-split (acl2-numberp y))
                (case-split (not (equal 0 x)))
                )
           (equal (equal 0 (* y x))
                  (equal 0 y))))


;rephrase? drop the two above?
(defthm equal-zero-product-split
  (implies (and (case-split (acl2-numberp x))
                (case-split (acl2-numberp y)))
           (equal (equal 0 (* x y))
                  (or (equal 0 x)
                      (equal 0 y)))))








#|


(defthm mult-both-sides-of-=
  (implies (and (rationalp a)
                (rationalp b)
                (rationalp c)
;                (not (equal c 0))
 ;              (> c 0)
                )
           (implies (equal a b)
                    (equal (* a c) (* b c))))
  :rule-classes nil)



(defthm cancel-factor-in-=-sums-2-1
  (implies (and (rationalp n)
                (not (equal n 0))
                (rationalp b)
                (rationalp a)
                (rationalp c)
 )
           (implies (EQUAL (+ (* N a)
                            (* N b))
                         (* N c))
                  (equal (+ a b) c)))
  :hints (("Goal" :in-theory (disable a9)
           :use (:instance mult-both-sides-of-= 
                                  (a (+ (* N a)
                                        (* N b)))
                                  (b (* N c))
                                  (c (/ n)))))
)
                  
|#

#|
(defthm collect-in-*
  (implies (and (rationalp x)
                (rationalp y)
                (rationalp a))
           (equal (BINARY-+ X
                            (BINARY-+ (BINARY-* (BINARY-+ '-1 A) Y)
                                      Y))
                  (+ X (* a Y)))))

(defthm collect-in-*-2
  (implies (and (integerp x)
                (integerp y)
                (integerp a))
           (equal (BINARY-+ X
                            (BINARY-+ (BINARY-* (BINARY-+ '-1 A) Y)
                                      Y))
                  (+ X (* a Y)))))

(defthm collect-in-*-3
  (implies (and (force (rationalp x))
                (force (rationalp y))
                (force (rationalp a)))
           (equal (+ (* (+ -1 A) Y) Y)
                  (+ (* a Y)))))

(defthm collect-in-*-4
  (implies (and (force (rationalp x))
                (force (rationalp y))
                (force (rationalp a)))
           (equal (+ (+ X (* (+ -1 A) Y)) Y)
                  (+ x (* a Y)))))
|#




(defthm collect-constants-with-division
  (implies (and (syntaxp (and (quotep c1) (quotep c2)))
                (rationalp c2)
                (acl2-numberp c1)
                (not (equal c2 0))
                (rationalp x))
           (equal (EQUAL c1 (* c2 x))
                  (equal (/ c1 c2) x))))


#|
(defthm <-prods-collect-constants-1-of-1-with-1-of-2
  (implies (and (syntaxp (and (quotep c1) (quotep c2)))
                (rationalp c2)
                (> c2 0)
                (rationalp c1)
                (not (equal c2 0))
                (rationalp x))
           (equal (< c1 (* c2 x))
                  (< (/ c1 c2) x)))
  
  )
|#



;fixed problem: quote instead of quotep
;each of these loops with something else
;(in-theory (disable collect-constants-with-division  
 ;                   <-prods-collect-constants-1-of-1-with-1-of-2))





;add until a rule like "cancel-times-lessp" gets added

(defthm cancel-times-<-eric
  (implies (and (rationalp x)
                (rationalp y)
                (rationalp z)
                (< 0 x) ;gen?
                )
           (equal (< (* x y) (* x z))
                  (< y z))))

(defthm cancel-times-<-eric-1
  (implies (and (rationalp x)
                (rationalp z)
                (< 0 x) ;gen?
                )
           (equal (< x (* x z))
                  (< 1 z))))

(DEFTHM CANCEL-TIMES-<-ERIC-1-better
  (IMPLIES (AND (<= 0 X)
                (case-split (not (equal x 0)))
                (case-split (RATIONALP X))
                (case-split (RATIONALP y))
                )
           (EQUAL (< X (* X y)) (< 1 y)))
)

(DEFTHM CANCEL-TIMES-<-ERIC-1-better-2
  (IMPLIES (AND (<= 0 X)
                (case-split (not (equal x 0)))
                (case-split (RATIONALP X))
                (case-split (RATIONALP y))
                )
           (EQUAL (< X (* y X)) (< 1 y)))
)

(in-theory (disable CANCEL-TIMES-<-ERIC-1))

(DEFTHM CANCEL-TIMES-<-ERIC-1-better-alt
  (IMPLIES (AND (<= 0 X)
                (case-split (not (equal x 0)))
                (case-split (RATIONALP X))
                (case-split (RATIONALP y))
                )
           (EQUAL (< (* X y) X) (< y 1)))
)

(DEFTHM CANCEL-TIMES-<-ERIC-2-better-alt
  (IMPLIES (AND (<= 0 X)
                (case-split (not (equal x 0)))
                (case-split (RATIONALP X))
                (case-split (RATIONALP y))
                )
           (EQUAL (< (* y X) X) (< y 1)))
)






#|

;; ==================================================================================================

comparing a product to 0

may cause case splits (which, for my purposes, is acceptable)

;; ==================================================================================================

|#


;case split on the sign of A
(defthm prod->-0-cancel-pos
  (implies (and (rationalp x)
                (rationalp a)
                (< 0 a))
           (equal (< 0 (* a x))
                  (< 0 x))))

(defthm prod-<-0-cancel-pos
  (implies (and (rationalp x)
                (rationalp a)
                (< 0 a))
           (equal (< (* a x) 0)
                  (< x 0))))


(defthm prod-<-0-cancel-neg
  (implies (and (rationalp x)
                (rationalp a)
                (< a 0))
           (equal (< (* a x) 0)
                  (< 0 x))))

(defthm prod->-0-cancel-neg
  (implies (and (rationalp x)
                (rationalp a)
                (< a 0))
           (equal (< 0 (* a x))
                  (< x 0))))

;reorder to make the most likely case of the if first?
(defthm prod->-0-cancel
  (implies (and (rationalp x)
                (rationalp a))
           (equal (< 0 (* a x))
                  (if (< 0 a)
                      (< 0 x)
                    (if (equal 0 a)
                        nil
                      (< x 0))))))

(defthm prod-<-0-cancel
  (implies (and (rationalp x)
                (rationalp a))
           (equal (< (* a x) 0)
                  (if (equal a 0)
                      nil
                    (if (< a 0)
                        (< 0 x)
                      (< x 0))))))

(in-theory (disable prod-<-0-cancel-neg prod-<-0-cancel-pos))



(in-theory (disable  prod->-0-cancel-neg  prod->-0-cancel-pos))



;is there an analogous series to the above for "equal"?




(defthm cancel-in-prods-<-case-x->-0
  (implies (and (rationalp x)
                (< 0 x)
                (rationalp a)
                (rationalp b))
           (equal  (< (* x a) (* x b))
                   (< a b)))
  )

(defthm cancel-in-prods-<-case-x-<-0
  (implies (and (rationalp x)
                (> 0 x)
                (rationalp a)
                (rationalp b))
           (equal  (< (* x a) (* x b))
                   (> a b)))
  )

;changed the var names 'cause "x" was too heavy
(defthm cancel-in-prods-<
  (implies (and (rationalp a)
                (rationalp b)
                (rationalp c))
           (equal (< (* a b) (* a c))
                  (if (equal 0 a)
                      nil
                    (if (> a 0)
                        (< b c)
                      (> b c))))))



(in-theory (disable cancel-in-prods-<-case-x-<-0 cancel-in-prods-<-case-x->-0))





(defthm cancel-in-prods-<-2-of-3-with-3-of-4
  (implies (and (rationalp x)
                (rationalp a)
                (rationalp b)
                (rationalp c)
                (rationalp d)
                (rationalp e)
                )
           (equal (< (* a x b) (* c e x d))
                  (if (equal x 0)
                      nil
                    (if (< 0 x)
                        (< (* a b) (* c e d))
                      (< (* c e d) (* a b))))))
  :hints (("Goal" :in-theory (disable cancel-in-prods-<)
           :use (:instance cancel-in-prods-< (a x) (b (* a b)) (c (* e c d))))))

(defthm cancel-in-prods-<-1-of-1-with-2-of-3
  (implies (and (rationalp x)
                (rationalp a)
                (rationalp b)
                )
           (equal (< x (* a x b))
                  (if (equal x 0)
                      nil
                    (if (< 0 x)
                        (< 1 (* a b))
                      (< (* a b) 1)))))
  :hints (("Goal" :in-theory (disable cancel-in-prods-<)
           :use (:instance cancel-in-prods-< (a x) (b 1) (c (* a b))))))

;*might* be a dup
(defthm cancel-in-prods-<-2-of-3-with-1-of-1
  (implies (and (rationalp x)
                (rationalp a)
                (rationalp b)

                )
           (equal (< (* a x b) x)
                  (if (equal x 0)
                      nil
                    (if (< 0 x)
                        (< (* a b) 1)
                      (< 1 (* a b))))))
  :hints (("Goal" :in-theory (disable cancel-in-prods-<)
           :use (:instance cancel-in-prods-< (a x) (b (* a b)) (c 1)))))

(defthm cancel-in-prods-<-1-of-2-with-1-of-1
  (implies (and (rationalp x)
                (rationalp a)

                )
           (equal (< (* x a) x)
                  (if (equal x 0)
                      nil
                    (if (< 0 x)
                        (< a 1)
                      (< 1 a)))))
  :hints (("Goal" :in-theory (disable cancel-in-prods-<)
           :use (:instance cancel-in-prods-< (a x) (b a) (c 1)))))

(defthm cancel-in-prods-<-3-of-4-with-3-of-4
  (implies (and (rationalp x)
                (rationalp a)
                (rationalp b)
                (rationalp c)
                (rationalp d)
                (rationalp e)
                (rationalp f)
                )
           (equal (< (* a f x b) (* c e x d))
                  (if (equal x 0)
                      nil
                    (if (< 0 x)
                        (< (* f a b) (* c e d))
                      (< (* c e d) (* f a b))))))
  :hints (("Goal" :in-theory (disable cancel-in-prods-<)
           :use (:instance cancel-in-prods-< (a x) (b (* f a b)) (c (* e c d))))))

(defthm cancel-in-prods-<-2-of-2-with-3-of-3
  (implies (and (rationalp x)
                (rationalp a)
                (rationalp b)
                (rationalp c)
                )
           (equal (< (* a x) (* b c x))
                  (if (equal x 0)
                      nil
                    (if (< 0 x)
                        (< a (* b c))
                      (< (* b c) a)))))
  :hints (("Goal" :in-theory (disable cancel-in-prods-<)
           :use (:instance cancel-in-prods-< (a x) (b a) (c (* b c))))))

(defthm cancel-in-prods-<-1-of-2-with-3-of-3
  (implies (and (rationalp x)
                (rationalp a)
                (rationalp b)
                (rationalp c)
                )
           (equal (< (* x a) (* b c x))
                  (if (equal x 0)
                      nil
                    (if (< 0 x)
                        (< a (* b c))
                      (< (* b c) a)))))
  :hints (("Goal" :in-theory (disable cancel-in-prods-<)
           :use (:instance cancel-in-prods-< (a x) (b a) (c (* b c))))))

(defthm cancel-in-prods-<-3-of-3-with-3-of-3
  (implies (and (rationalp x)
                (rationalp a)
                (rationalp b)
                (rationalp c)
                (rationalp d)
                )
           (equal (< (* a d x) (* b c x))
                  (if (equal x 0)
                      nil
                    (if (< 0 x)
                        (< (* a d) (* b c))
                      (< (* b c) (* a d))))))
  :hints (("Goal" :in-theory (disable cancel-in-prods-<)
           :use (:instance cancel-in-prods-< (a x) (b (* a d )) (c (* b c))))))

;better to use (casesplit (not (equal x 0)))
(defthm cancel-in-prods-<-2-of-2-with-2-of-3
  (implies (and (rationalp x)
                (rationalp a)
                (rationalp b)
                (rationalp c)
                )
           (equal (< (* a x) (* b x c))
                  (if (equal x 0)
                      nil
                    (if (< 0 x)
                        (< (* a) (* b c))
                      (< (* b c) (* a))))))
  :hints (("Goal" :in-theory (disable cancel-in-prods-<)
           :use (:instance cancel-in-prods-< (a x) (b (* a)) (c (* b c))))))


;use negative-syntaxp? (or a version of it that operates on single addends only (i.e., has not '+ case)
;move to arith
(defthm move-a-negative-coeff
  (equal (< (+ a (* -1 b)) c)
         (< a (+ b c))))
  

(in-theory (disable  move-a-negative-coeff))

;can simplify the *-1 term to have only one var 
(defthm rearr-negative-coeffs-<-sums-blah
  (equal (< (+ A e (* -1 C f D)) B)
         (< (+ A e) (+ (* C f D) B)))
  :hints (("Goal" :use (:instance
                        move-a-negative-coeff (a (+ a e)) (b (* c f d)) (c b)))))




(defthm collect-constant-mults-<-1-of-2-with-1-of-2-term-len-2
  (implies (and (syntaxp (and (quotep c1) (quotep c2)))
                (rationalp c1)
                (rationalp c2)
                (rationalp a)
                (rationalp b)
                (rationalp c)
                (rationalp d))
           (equal (< (+ (* c1 c d) a) (+ (* c2 c d) b))
                  (< (+ (* (- c1 c2) c d) a) b))))


(defthm cancel-common-factor-in-<-blah
  (implies (and (rationalp a)
                (rationalp b)
                (rationalp c)
                (rationalp d)
                (rationalp e)
                (rationalp f)
                (rationalp g)
                (rationalp h)
                (rationalp x)
                (< 0 x))
           (equal (< (* f g x h)
                     (+ (* a x b)
                        (* c d x e)))
                  (< (* f g h)
                     (+ (* a b)
                        (* c d e)))))
  :hints (("Goal" :use ((:instance mult-both-sides-of-<-by-positive
                                   (a (* f g h))
                                   (b (+ (* a b)
                                         (* c d e)))
                                   (c x))))))

(defthm cancel-common-factor-in-<-blah-4
  (implies (and (rationalp a)
                (rationalp b)
                (rationalp c)
                (rationalp d)
                (rationalp e)

                (rationalp x)
                (< 0 x))
           (equal (< (* d e x)
                     (+ (* a x)
                        (* b c x)))
                  (< (* d e)
                     (+ a
                        (* b c)))))
  :hints (("Goal" :use ((:instance mult-both-sides-of-<-by-positive
                                   (a (* d e))
                                   (b (+ (* a)
                                         (* b c)))
                                   (c x))))))

(defthm cancel-common-factor-in-<-blah-2
  (implies (and (rationalp a)
                (rationalp b)
                (rationalp c)
                (rationalp d)
                (rationalp e)
                (rationalp f)
                (rationalp g)
                (rationalp h)
                (rationalp x)
                (< 0 x))
           (equal (< (* a x b)
                     (+ (* c x d)
                        (* e f x g)))
                  (< (* a b)
                     (+ (* c d)
                        (* e f g)))))
  :hints (("Goal" :use ((:instance mult-both-sides-of-<-by-positive
                                   (a (* a b))
                                   (b (+ (* c d)
                                         (* e f g)))
                                   (c x))))))

(defthm cancel-common-factor-in-<-blah-3
  (implies (and (rationalp a)
                (rationalp b)
                (rationalp c)
                (rationalp d)

                (rationalp x)
                (< 0 x))
           (equal (< (* a x)
                     (+ (* b x)
                        (* c d x)))
                  (< a
                     (+ b
                        (* c d)))
                  ))
  :hints (("Goal" :use ((:instance mult-both-sides-of-<-by-positive
                                   (a a)
                                   (b                      (+ b
                                                              (* c d)))
                                   (c x))))))


(defthm cancel-common-factor-in-<-blah-two-gazillion
  (implies (and (rationalp a)
                (rationalp b)
                (rationalp c)
                (rationalp d)
                (rationalp e)
                (rationalp f)
                (rationalp x)
                (< 0 x))
           (equal (< (* f x)
                     (+ (* a b x)
                        (* c d x e)))
                  (< f
                     (+ (* a b)
                        (* c d e)))))
  :hints (("Goal" :use ((:instance mult-both-sides-of-<-by-positive
                                   (a (* f))
                                   (b (+ (* a b)
                                         (* c d e)))
                                   (c x))))))
(include-book "frac-coeff")


;events in :rule-classes nil which can be :used in hacks

(defthm <-transitive
  (implies (and (< a b)
                (< b c)
                )
           (< a c)
           )
  :rule-classes nil
  )

(defthm <=-transitive
  (implies (and (<= a b)
                (<= b c)
                )
           (<= a c)
           )
  :rule-classes nil
  )

;a<b and b<=c together imply a<c
(defthm <-and-<=-transitivity
  (implies (and (< a b)	
                (<= b c)	
                )
           (< a c)
           )
  :rule-classes nil
  )

;a<=b and b<c together imply a<c
(defthm <=-and-<-transitivity
  (implies (and (< a b)	
                (<= b c)	
                )
           (< a c)
           )
  :rule-classes nil
  )



(defthm cancel-in-prods-<-2-of-3-with-3-of-3
  (implies (and (rationalp x)
                (rationalp a)
                (rationalp b)
                (rationalp c)
                (rationalp d)
                )
           (equal (< (* a x d) (* b c x))
                  (if (equal x 0)
                      nil
                    (if (< 0 x)
                        (< (* a d) (* b c))
                      (< (* b c) (* a d))))))
  :hints (("Goal" :in-theory (disable cancel-in-prods-<)
           :use (:instance cancel-in-prods-< (a x) (b (* a d )) (c (* b c))))))





;used only as a hack
;collect hacks like this

(defthm equal-transitive
  (implies (and (equal a b)
                (equal b c))
           (equal a c))
  :rule-classes nil)


(defthm cancel-in-prods-<-2-of-2-with-2-of-2
  (implies (and (rationalp x)
                (rationalp a)
                (rationalp b)
                )
           (equal (< (* a x) (* b x))
                  (if (equal x 0)
                      nil
                    (if (< 0 x)
                        (< a b)
                      (< b a)))))
  :hints (("Goal" :in-theory (disable cancel-in-prods-<)
           :use (:instance cancel-in-prods-< (a x) (b a) (c b)))))





;move
(defthm 0-<-/
  (implies (rationalp x)
           (equal (< 0 (/ x))
                  (< 0 x)))
  :hints (("Goal" :cases ((< 0 x) (equal x 0))))
)

;move
(defthm 0->-/
  (implies (rationalp x)
           (equal (< (/ x) 0)
                  (< x 0)))
  :hints (("Goal" :cases ((< 0 x) (equal x 0))))
)

;there's a conflict in my arithmetic normal forms:
; do we prefer (< (* 2 x) 1) or (< x 1/2) ?

#|
(defthm cancel-special-500
  (implies (and (syntaxp (and (quotep k) (quotep j)))
                (rationalp k)
                (rationalp j)
                (case-split (rationalp x))
                
                (case-split (not (equal j 0)))
                (case-split (< 0 j)))
           (equal (< (* j x) k)
                  (< x (/ k j))))
  :hints (("Goal" :in-theory (enable  equal-of-preds-rewrite)))
)

|#


(defthm cancel-in-prods-<-3-of-3-with-2-of-2
  (implies (and (rationalp x)
                (rationalp a)
                (rationalp b)
                (rationalp c)

                )
           (equal (< (* a b x) (* c x))
                  (if (equal x 0)
                      nil
                    (if (< 0 x)
                        (< (* a b) (* c))
                      (< (* c) (* a b))))))
  :hints (("Goal" :in-theory (disable cancel-in-prods-<)
           :use (:instance cancel-in-prods-< (a x) (b (* a b)) (c c)))))


(defthm collect-again
  (implies (and (syntaxp (quotep k))
                (rationalp x)
                (rationalp y))
           (equal (< (+ x y) (* k x))
                  (< y (* (- k 1) x)))))









;this is defined here to try to make sure its always enabled in elib

;(DEFUN NATP (X)
;  (AND (INTEGERP X) (>= X 0)))

(in-theory (enable natp))

;an odd rule
(defthm two-natps-add-to-1
  (implies (and (natp n)
                (natp x))
           (equal (equal 1 (+ x n))
                  (or (and (equal x 1) (equal n 0))
                      (and (equal x 0) (equal n 1))))))

;backchain-limit?
;why needed?
(defthm nonneg-+
  (implies (and (<= 0 x)
                (<= 0 y))
           (not (< (+ x y) 0))))

;improve this? make the conclusion more type-like?
(defthm nonneg-+-type
  (implies (and (<= 0 x)
                (<= 0 y))
           (not (< (+ x y) 0)))
  :rule-classes (:type-prescription))



(defthm move-negative-constant-1
  (implies (and (syntaxp (and (quotep k) (< (cadr k) 0)))
                (acl2-numberp x)
                (acl2-numberp y))
           (equal (equal x (+ k y))
                  (equal (+ x (- k)) y))))

(defthm cancel-special-300
  (implies (and (rationalp x)
                (case-split (not (equal 0 x)))
                (rationalp a)
                (rationalp b)
                (rationalp c)
                (rationalp d)
                (rationalp e)
                (rationalp f)
                (rationalp g)
                )
           (equal (EQUAL (+ (* a x b)
                            (* x c))
                         (+ (* d x e)
                            (* f x g)))
                  (EQUAL (+ (* a b)
                            c)
                         (+ (* d e)
                            (* f g)))))
  :hints (("Goal" :use (:instance mult-both-sides-of-equal
                                   (a (+ (* a b) c))
                                   (b (+ (* d e)
                                         (* f g)))
                                   (c x)))))


(defthm cancel-special-301
  (implies (and (rationalp x)
                (case-split (not (equal 0 x)))
                (rationalp a)
                (rationalp b)
                (rationalp c)
                (rationalp d)
                (rationalp e)
                (rationalp f)
                (rationalp g)
                (rationalp h)
                (rationalp i)
                (rationalp j)
                (rationalp k)
                (rationalp l)
                (rationalp m)
                )
           (equal (EQUAL (+ (* a b x)
                            (* c d x))
                         (+ (* e f g x h)
                            (* i j k l x m)))
                  (EQUAL (+ (* a b)
                            (* c d))
                         (+ (* e f g h)
                            (* i j k l m)))))
  :hints (("Goal" :use (:instance mult-both-sides-of-equal
                                  (a (+ (* a b)
                                        (* c d)))
                                  (b (+ (* e f g h)
                                        (* i j k l m)))
                                  (c x)))))


(defthm rationalp-sum
  (implies (rationalp k)
           (and (equal (rationalp (+ k x))
                       (not (complex-rationalp x)))
                (equal (rationalp (+ x k))
                       (not (complex-rationalp x))))))


;make rationalp-sum like this?
(defthm rationalp-prod
  (implies (and (rationalp k)
                (case-split (not (equal k 0)))
                )
           (and (equal (rationalp (* k x))
                       (not (complex-rationalp x)))
                (equal (rationalp (* x k))
                       (not (complex-rationalp x))))))

(defthm complex-rationalp-prod
  (implies (and (rationalp k)
                (case-split (not (equal k 0)))
                )
           (and (equal (complex-rationalp (* k x))
                       (complex-rationalp x))
                (equal (complex-rationalp (* x k))
                       (complex-rationalp x)))))



(defthm collect-1
  (implies (and (syntaxp (and (quotep k) (quotep j)))
                (rationalp k)
                (rationalp j)
                (rationalp x)
                (rationalp y)
                )
           (equal (< (+ y (* k x)) (* j x))
                  (< (+ (* (- k j) x) y) 0))))

(defthm collect-2
  (implies (and (syntaxp (and (quotep k) (quotep j)))
                (rationalp k)
                (rationalp j)
                (rationalp x)
                (rationalp y)
                )
           (equal (< (+ (* k x) y) (* j x))
                  (< (+ (* (- k j) x) y) 0))))

(defthm collect-another
  (implies (and (syntaxp (and (quotep k) (quotep j)))
                (rationalp k)
                (rationalp j)
                (rationalp x)
                (rationalp y)
                (rationalp z))
           (equal (< (+ (* k x) y) (+ (* j x) z))
                  (< (+ (* (- k j) x) y) z))))



(defthm cancel-another-2
  (implies (and (case-split (< 0 x)) ;the problem hyp
                (rationalp w)
                (rationalp v)
                (rationalp x)
                (rationalp y)
                (rationalp z))
           (equal (< (+ (* y x) (* z w x)) (* v x))
                  (< (+ y (* z w)) v)))
  :hints (("Goal" :use (:instance mult-both-sides-of-<-by-positive 
                                  (a (+ y (* z w)))
                                  (b v)
                                  (c x)))))

;simplify this
(defthm collect-in-<-of-sums-2
  (implies (syntaxp (and (quotep k) (quotep j)))
           (equal (< (+ a (* k x) d) (+ b e (* j       x) f))
                  (< (+ a         d) (+ b e (* (- j k) x) f)))))

(defthm collect-in-<-of-sums-1
  (implies (syntaxp (and (quotep k) (quotep j)))
           (equal (< (+ a d (* k x) y) (+ b e f z (* j       x) g))
                  (< (+ a d         y) (+ b e f z (* (- j k) x) g)))))

(defthm cancel-sheesh
  (implies (and (>= x 0)
                (rationalp y1)
                (rationalp y2)
                (rationalp y3)
                (rationalp y4)
                (rationalp x)
                (case-split (not (equal x 0))))
           (equal (< (* y1 x)
                     (+ (* y2 x)
                        (* y3 y4 x)))
                  (< y1
                     (+ y2
                        (* y3 y4)))))
  :hints (("Goal" :use (:instance cancel-in-prods-<-case-x->-0 (a y1) (b (+ y2 (* y3 y4))))))
  )



(defthm cancel-again
  (implies (and (case-split (not (equal 0 x))) ;the problem hyp
                (rationalp w)
                (rationalp v)
                (rationalp x)
                (rationalp y)
                (rationalp z)
                (rationalp r)
                (rationalp s)
                (rationalp u))
           (equal (EQUAL (+ (* X Y) (* X Z))
                         (* S U V W X r))
                  (EQUAL (+ Y Z)
                         (* S U V W r))))
  :hints (("Goal"  :use (:instance mult-both-sides-of-equal (a (+ Y Z)) (b                          (* S U V W r)) (c x)))))


(defthm cancel-in-sum-equal-zero-1
  (implies (and (rationalp y)
                (case-split (not (equal 0 y)))
                (rationalp x1)
                (rationalp x2)
                (rationalp x3)
                (rationalp x4)
                (rationalp x5)
                (rationalp x6))
           (equal (EQUAL 0 (+ (* Y x1)
                              (* x2 Y x3)
                              (* Y x4)
                              (* x5 Y x6)))
                  (equal 0 (+ x1 (* x2 x3) x4 (* x5 x6)))))
  :hints (("Goal" :in-theory (disable equal-zero-product)
           :use (:instance equal-zero-product (x y) (y (+ x1 (* x2 x3) x4 (* x5 x6))))))
  
  )

(defthm cancel-again-2
  (implies (and (case-split (not (equal 0 x))) ;the problem hyp
                (rationalp w)
                (rationalp v)
                (rationalp x)
                (rationalp y)
                (rationalp z)
                (rationalp r)
                (rationalp s)
                (rationalp u))
           (equal (EQUAL (+ (* X Y) (* s X Z))
                         (+ (* X u) (* r X w)))
                  (EQUAL (+ Y (* s Z))
                         (+ u (* r w)))))
  :hints (("Goal"  :use (:instance mult-both-sides-of-equal 
                                    (a (+ Y (* s Z)))
                                    (b (+ u (* r w)))
                                    (c x)))))

(defthm integerp-implies-not-complex-rationalp
  (implies (integerp x)
           (not (complex-rationalp x))))









(defthm cancel-123
  (IMPLIES (AND (CASE-SPLIT (RATIONALP X))
                (case-split (NOT (EQUAL X 0)))
                (CASE-SPLIT (RATIONALP Y))
                (CASE-SPLIT (RATIONALP Z))
                (CASE-SPLIT (RATIONALP W))
                (CASE-SPLIT (RATIONALP U))
                (CASE-SPLIT (RATIONALP S))
                (CASE-SPLIT (RATIONALP R))
                (CASE-SPLIT (RATIONALP p))
                (CASE-SPLIT (RATIONALP q)))
           (equal (EQUAL (+ (* X Y) (* X Z))
                         (+ (* V W X q)
                            (* R S U X p)))
                  (EQUAL (+ Y Z)
                         (+ (* V W q)
                            (* R S U p)))))
  :hints (("Goal"  :use (:instance mult-both-sides-of-equal 
                                    (a (+ Y Z))
                                    (b (+ (* V W q)
                                          (* R S U p)))
                                    (c x)))))


(defthm cancel-122
  (IMPLIES (AND (CASE-SPLIT (RATIONALP X))
                (case-split (NOT (EQUAL X 0)))
                (CASE-SPLIT (RATIONALP Y))
                (CASE-SPLIT (RATIONALP Z))
                (CASE-SPLIT (RATIONALP W))
                (CASE-SPLIT (RATIONALP U))
                (CASE-SPLIT (RATIONALP S))
                (CASE-SPLIT (RATIONALP R))
                (CASE-SPLIT (RATIONALP p))
                (CASE-SPLIT (RATIONALP q)))
           (equal (EQUAL (+ (* X Y) (* X Z))
                         (+ (* V W q X m)
                            (* R S U p X n)))
                  (EQUAL (+ Y Z)
                         (+ (* V W m q)
                            (* R S U n p)))))
  :hints (("Goal"  :use (:instance mult-both-sides-of-equal 
                                    (a (+ Y Z))
                                    (b                          (+ (* V W q m)
                                                                   (* R S U p n)))
                                    (c x)))))

(defthm cancel-124
  (IMPLIES (AND (CASE-SPLIT (RATIONALP X))
                (case-split (NOT (EQUAL X 0)))
                (CASE-SPLIT (RATIONALP Y))
                (CASE-SPLIT (RATIONALP Z))
                (CASE-SPLIT (RATIONALP W))
                (CASE-SPLIT (RATIONALP U))
                (CASE-SPLIT (RATIONALP S))
                (CASE-SPLIT (RATIONALP R))
                )
           (equal (EQUAL (+ (* W X) (* U V X))
                         (+ (* X Y r)
                            (* X Z s)))
                  (EQUAL (+ W (* U V))
                         (+ (* Y r)
                            (* Z s)))))
  :hints (("Goal"  :use (:instance mult-both-sides-of-equal 
                                    (a (+ W (* U V)))
                                    (b (+ (* Y r)
                                          (* Z s)))
                                    (c x)))))

(defthm cancel-129
  (IMPLIES (AND (CASE-SPLIT (RATIONALP X))
                (case-split (NOT (EQUAL X 0)))
                (CASE-SPLIT (RATIONALP Y))
                (CASE-SPLIT (RATIONALP Z))
                (CASE-SPLIT (RATIONALP W))
                (CASE-SPLIT (RATIONALP U))
                (CASE-SPLIT (RATIONALP R))
                )
           (equal (EQUAL (+ (* W X) (* U X))
                         (+ (* Y X) (* Z r X)))
                  (EQUAL (+ W U)
                         (+ (* Y)
                            (* Z r)))))
  :hints (("Goal"  :use (:instance mult-both-sides-of-equal 
                                    (a (+ W u))
                                    (b (+ Y
                                          (* Z r)))
                                    (c x)))))

(defthm cancel-130
  (IMPLIES (AND (CASE-SPLIT (RATIONALP X))
                (case-split (NOT (EQUAL X 0)))
                (CASE-SPLIT (RATIONALP Y))
                (CASE-SPLIT (RATIONALP Z))
                (CASE-SPLIT (RATIONALP W))
                (CASE-SPLIT (RATIONALP U))
                (CASE-SPLIT (RATIONALP R))
                )
           (equal (EQUAL (+ (* W X) (* U X))
                         (* Y z X r))
                  (EQUAL (+ W U)
                         (* Y  Z r))))
  :hints (("Goal"  :use (:instance mult-both-sides-of-equal 
                                    (a (+ W u))
                                    (b (* Y Z r))
                                    (c x)))))










(defthm cancel-125
  (IMPLIES (AND (<= 0 x)
                (CASE-SPLIT (RATIONALP X))
                (case-split (NOT (EQUAL X 0)))
                (CASE-SPLIT (RATIONALP Y))
                (CASE-SPLIT (RATIONALP Z))
                (CASE-SPLIT (RATIONALP W))
                (CASE-SPLIT (RATIONALP U))
                (CASE-SPLIT (RATIONALP S))
                )
           (equal (< (* W X)
                     (+ (* Y X)
                        (* Z s X)))
                  (< w
                     (+ y
                        (* Z s)))))
  :hints (("Goal"  :use (:instance mult-both-sides-of-<-by-positive
                                    (a w)
                                    (b (+ y
                                          (* Z s)))
                                    (c x)))))

(defthm cancel-126
  (IMPLIES (AND (<= 0 x)
                (case-split (NOT (EQUAL X 0)))
                (CASE-SPLIT (RATIONALP X))
                (CASE-SPLIT (RATIONALP Y))
                (CASE-SPLIT (RATIONALP Z))
                (CASE-SPLIT (RATIONALP W))
                (CASE-SPLIT (RATIONALP U))

                )
           (equal (< (* W X)
                     (+ (* Y X)
                        (* Z X)))
                  (< w (+ y Z))))
  :hints (("Goal"  :use (:instance mult-both-sides-of-<-by-positive
                                    (a w)
                                    (b (+ y
                                          (* Z)))
                                    (c x)))))


(defthm cancel-wow
  (implies (and (case-split (not (equal x 0)))
                (case-split (rationalp x))
                (case-split (rationalp a))
                (case-split (rationalp b))
                (case-split (rationalp c))
                (case-split (rationalp d))
                (case-split (rationalp e))
                (case-split (rationalp f))
                (case-split (rationalp g))
                (case-split (rationalp h))
                (case-split (rationalp u))
                (case-split (rationalp j))
                (case-split (rationalp k))
                (case-split (rationalp l))
                (case-split (rationalp m))
                (case-split (rationalp n)))
           (equal (EQUAL (+ (* a x)
                            (* b x c)
                            (* d x e)
                            (* x f))
                         (+ (* g x)
                            (* h x i)
                            (* j x k)
                            (* l x m n)))
                  (EQUAL (+ a
                            (* b c)
                            (* d e)
                            f)
                         (+ g
                            (* h i)
                            (* j k)
                            (* l m n)))))
  :hints (("Goal"   :use (:instance mult-both-sides-of-equal
                                    (a (+ a
                            (* b c)
                            (* d e)
                            f))
                                    (b                          (+ g
                            (* h i)
                            (* j k)
                            (* l m n))) (c x)))))
                  






(defthm collect-eric
 (equal (< (+ x y) (* c y))
        (< x (* (+ -1 c) y))))


(defthm cancel-131
  (IMPLIES (AND (CASE-SPLIT (RATIONALP X))
                (case-split (NOT (EQUAL X 0)))
                (CASE-SPLIT (RATIONALP Y))
                (CASE-SPLIT (RATIONALP Z))
                (CASE-SPLIT (RATIONALP W))
                (CASE-SPLIT (RATIONALP U))
                (CASE-SPLIT (RATIONALP R))
                (CASE-SPLIT (RATIONALP a))
                )
           (equal (EQUAL (+ (* W X y) (* U z X a))
                         (* X r))
                  (EQUAL (+ (* W y) (* U z a))
                         r)))
  :hints (("Goal"  :use (:instance mult-both-sides-of-equal 
                                    (a (+ (* W y) (* U z a)))
                                    (b r)
                                    (c x)))))


;don't need this if we have frac-coeff rules?
(defthm <-of-two-inverses
  (implies (and (rationalp x)
                (rationalp y)
                (< 0 y)
                (< 0 x)
                )
           (equal (< (/ x) (/ y))
                  (< y x))))
