(in-package "ACL2")

;(local (include-book "bits"))
(local (include-book "bits2"))
(local (include-book "expt2"))
(local (include-book "mod"))
(local (include-book "bvecp"))
(local (include-book "arith"))

(include-book "rtl")



#|
(defun COMP1 (x n)
  (1- (- (expt 2 n) x)))
|#

(defun COMP1 (x n)
   (if (natp n)
       (+ -1 (expt 2 n) (- (bits x (+ -1 n) 0)))
     0))

(in-theory (disable comp1))

;note that this isn't a rewrite rule b/c we believe it will never need to be
(defthm comp1-nonnegative-integer-type
  (and (integerp (comp1 x n))
       (<= 0 (comp1 x n)))
  :hints (("Goal" :in-theory (enable comp1)))
  :rule-classes ((:type-prescription :typed-term (comp1 x n))))

;comp1-nonnegative-integer-type is strictly better, and we don't need both
(in-theory (disable (:type-prescription comp1))) 

(defthm comp1-natp
  (natp (comp1 x n)))

(defthm COMP1-upper-bound
  (< (comp1 x n) (expt 2 n))
    :hints (("Goal" :in-theory (enable comp1)))
  :rule-classes (:rewrite :linear)
)

;why is bvecp enabled here?

(defthm comp1-bvecp-simple
  (bvecp (comp1 x n) n)
  :hints (("Goal" :in-theory (enable bvecp comp1))))

(in-theory (disable bvecp))

(defthm comp1-bvecp
  (implies (and (<= n k)
                (case-split (integerp k)))
           (bvecp (comp1 x n) k))
  :hints (("Goal" :in-theory (disable comp1-bvecp-simple)
           :use comp1-bvecp-simple)))

(defthm COMP1-COMP1
  (implies (and (case-split (natp n)); (integerp n)
                (case-split (bvecp x n)) ;added
                )
           (= (comp1 (comp1 x n) n)
              x))
  :hints (("Goal" :in-theory (enable comp1 bvecp bits-does-nothing))))

;turn this around? disable it?
(defthm comp1-2+1
   (implies (and (case-split (natp x))
                 (case-split (natp n))
                 )
            (equal (+ 1 (* 2 (comp1 x n)))
                   (comp1 (* 2 x) (1+ n))))
   :hints (("Goal" :in-theory (enable comp1 expt-split)
            :use (:instance bits-shift (n 1) (i n) (j 0)))))

#|
(in-theory (disable mod))
(defthm bits-comp1
   (implies (and (natp m) 
                 (natp i) 
                 (natp j)
                 (> m i)
                 (>= i j)
                 (bvecp x m))
            (equal (bits (comp1 x m) i j)
                   (comp1 (bits x i j) (1+ (- i j)))))
   :hints (("Goal" :in-theory (enable bits comp1)))
   )
|#

(defthm comp1-with-n-0
  (equal (comp1 x 0)
         0)
  :hints (("Goal" :in-theory (enable comp1)))
  )