(in-package "ACL2")

(include-book "power2p")
(include-book "negative-syntaxp")
(local (include-book "predicate"))
(local (include-book "fp2"))
(local (include-book "numerator"))
(local (include-book "denominator"))
(include-book "fl2") ;remove
(local (include-book "arith2"))

(in-theory (disable expt))

(encapsulate 
 ()
 (local (include-book "../../../arithmetic/top"))
 (defthm a16
   (equal (expt (* a b) i)
          (* (expt a i) (expt b i)))
   :hints
   (("Goal" :in-theory (enable distributivity-of-expt-over-*))))

;gen
;split off the non-integer case
 (defthm expt-split
   (implies (and (integerp i1)
                 (integerp i2)
                 (case-split (acl2-numberp r)) ;(integerp r)
                 (case-split (not (equal r 0)))
                 )
            (equal (expt r (+ i1 i2))
                   (* (expt r i1)
                      (expt r i2))))
   :hints (("Goal" :in-theory (enable expt)))
   )
 )

(defthm expt-2-positive-rational-type
   (and (rationalp (expt 2 i))
        (< 0 (expt 2 i)))
   :hints (("Goal" :in-theory (enable expt) ))
   :rule-classes ((:type-prescription :typed-term (expt 2 i))))


(in-theory (disable expt-split))

#|
(defthm expt-2-reduce-leading-constant-gen
  (implies (case-split (integerp (+ k d)))
           (equal (expt 2 (+ k d))
                  (* (expt 2 (fl k)) (expt 2 (+ (mod k 1) d)))))
  :otf-flg t
   :hints (("Goal" :in-theory (set-difference-theories
                                (enable; fl
)
                                '(expt-split mod))
             :use (:instance expt-split (r 2) (i1 (fl k)) (i2 (+ (mod k 1) d))))))
|#

(include-book "float")


(defun power2p-alt (x)
  (equal x (expt 2 (expo x))))

(defthm expt-between-one-and-two
  (IMPLIES (AND (<= 1 (EXPT 2 x))
                (< (EXPT 2 x) 2))
           (EQUAL (EXPT 2 x) 1))
  :hints (("Goal" 
           :in-theory (enable expt zip))
          ("subgoal *1/7" :use (:instance expt-monotone (n (+ x 1)) (m 0)))))

(in-theory (disable  expt-between-one-and-two))

(defthm expo-shift-1
  (IMPLIES (AND (case-split (RATIONALP X)) ;if not, we want to know about it
                (case-split (NOT (= X 0))) ;if x=0 we can simplify further
                )
           (= (EXPO (* 1/2 X))
              (+ -1 (EXPO X))))
  :HINTS (("Goal" :USE (:instance SIG-EXPO-SHIFT (n -1)))))

(defthm expo-shift-1-2
  (IMPLIES (AND (case-split (RATIONALP X)) ;if not, we want to know about it
                (case-split (NOT (= X 0))) ;if x=0 we can simplify further
                )
           (= (EXPO (* 2 X))
              (+ 1 (EXPO X))))
  :HINTS (("Goal" :USE (:instance SIG-EXPO-SHIFT (n 1)))))


(defthm power2p-rewrite
  (equal (POWER2P X)
         (EQUAL X (EXPT 2 (EXPO X))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable power2p
                                      expt-split
                                      expt-between-one-and-two
                                      )
                              
                              '(POWER2P-SHIFT)))))

(in-theory (disable  power2p-rewrite))

(defthm expt2-integer
  (implies (case-split (integerp i))
           (equal (integerp (expt 2 i))
                  (<= 0 i)))
  :hints (("Goal" :in-theory (enable expt expt-split))))

;(in-theory (disable power2p-rewrite))
;(local (in-theory (enable power2p-rewrite)))

(defthm expt-compare-old
   (implies (and (case-split (integerp i1))
                 (case-split (integerp i2)))
            (equal (< (EXPT 2 i1) (expt 2 i2))
                   (< i1 i2)))
            :hints (("Goal" :use ( (:instance expt-strong-monotone (n i2) (m i1))
                                   (:instance expt-strong-monotone (n i1) (m i2))))))

(in-theory (disable expt-compare-old))

(DEFTHM EXPT-COMPARE
  (IMPLIES (AND (syntaxp (and (power2-syntaxp lhs)
                              (power2-syntaxp rhs)))
                (case-split (power2p lhs))
                (case-split (power2p rhs)))
           (equal (< lhs rhs)
                  (< (expo lhs) (expo rhs))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable power2p-rewrite expt)
                              '(EXPT-COMPARE-old POWER2P-SHIFT))
           :use (:instance expt-compare-old (i1 (expo lhs)) (i2 (expo rhs)))
           ))
  :otf-flg t
  )

(DEFTHM EXPT-COMPARE-equal
  (IMPLIES (AND (syntaxp (and (power2-syntaxp lhs)
                              (power2-syntaxp rhs)))
                (case-split (power2p lhs)) ;if the syntacp hyp goes through we expect these to also
                (case-split (power2p rhs))
                )
           (equal (equal lhs rhs)
                  (equal (expo lhs) (expo rhs))))
  :hints (("Goal"  :in-theory (set-difference-theories
                               (enable power2p-rewrite expt)
                               '(EXPT-COMPARE-old POWER2P-SHIFT))

           ))
)



(defthm power2-integer
  (implies (and (syntaxp (power2-syntaxp x))
                (force (power2p x)))
           (equal (integerp x)
                  (<= 0 (expo x))))
  :hints (("Goal" :use (:instance expt2-integer (i (expo x)))
             :in-theory (set-difference-theories
                         (enable power2p-rewrite expt)
                         '( POWER2P-SHIFT expt2-integer)))))

(defthm expt-with-i-non-integer
  (implies (not (integerp i))
           (equal (expt r i)
                  1))
  :hints (("Goal" :in-theory (enable expt)))
)

(defthm power2p-expt
  (power2p (expt 2 i))
  :hints (("Goal" :cases ((integerp i))
           :in-theory (enable power2p expt))))

(local (include-book "integerp"))

(defthm expt-minus-helper
  (equal (expt r (* -1 i))
         (/ (expt r i)))
  :otf-flg t
  :hints (("Goal" :cases ((integerp i) (and (not (integerp i)) (acl2-numberp i)))
           :in-theory (enable expt)))
)
(in-theory (disable expt-minus-helper))

(defthm expt-minus
  (implies (syntaxp (negative-syntaxp i))
           (equal (expt r i)
                  (/ (expt r (* -1 i)))))
  :hints (("Goal" :in-theory (enable expt-minus-helper
                                     expt-split))))

(in-theory (disable expt-minus))

