(in-package "ACL2")

;setbits should include setbits2, not the other way around, as currently

(include-book "rtl")
(local (include-book "setbits2"))
(local (include-book "setbits"))
(local (include-book "arith"))
(local (include-book "integerp"))

(local (in-theory (disable setbits-rewrite setbits-rewrite-when-j-is-0)))
(local (in-theory (disable bits cat)))

(defun setbitn (x w n y)
  (setbits x w n n y))
(in-theory (disable setbitn))

(defthm setbitn-nonnegative-integer-type
  (and (integerp (setbitn x w n y))
       (<= 0 (setbitn x w n y)))
  :hints (("Goal" :in-theory (enable setbitn)))
  :rule-classes (:type-prescription)
  )

;this rule is no better than setbits-nonnegative-integer-type and might be worse:
(in-theory (disable (:type-prescription setbitn)))

(defthm setbitn-natp
  (natp (setbitn x w n y)))

;prove bitn-setbitn lemmas, etc., bvecp-setbitn?

(defthm setbitn-bvecp
  (implies (and (<= w k)
                (case-split (integerp k)))
           (bvecp (setbitn x w n y) k))
  :hints (("goal" :in-theory (enable setbitn))))


(defthm setbitn-rewrite
  (implies (syntaxp (quotep n))
           (equal (setbitn x w n y)
                  (setbits x w n n y)))
  :hints (("Goal" :in-theory (enable setbitn))))

(defthm bitn-setbitn
  (implies (and (case-split (bvecp y 1))
                (case-split (< 0 w))
                (case-split (< n w))
                (case-split (< n2 w))
                (case-split (<= 0 n2))
                (case-split (integerp w))
                (case-split (integerp n))
                (<= 0 n)
                (case-split (integerp n2))
                )
           (equal (bitn (setbitn x w n y) n2)
                  (if (equal n n2)
                      y
                    (bitn x n2))))
  :hints (("Goal" :cases ((< n n2) (= n n2))
           :in-theory (enable setbitn bitn bits-reduce)))
  )



(defthm setbitn-setbitn
  (implies (and (case-split (<= 0 n))
                (case-split (< n w))
                (case-split (integerp w))
                (case-split (integerp n))
                )
           (equal (setbitn (setbitn x w n y) w n y2)
                  (setbitn x w n y2)))
  :hints (("Goal"
           :in-theory (enable setbitn setbits-rewrite setbits-rewrite-when-j-is-0 bits-bits natp)))
  )

;generalize this after generalizing cat-bits-bits
(defthm setbitn-same-bitn
  (implies (and ;(case-split (bvecp x w))
            (case-split (integerp x))
            (case-split (<= 0 x))
            (case-split (<= 0 n))
            (< 0 n)
            (case-split (< n w))
            (case-split (integerp w))
            (case-split (integerp n))
            )
           (equal (setbitn x w n (bitn x n))
                  (bits x (+ -1 w) 0))
           )
  :hints (("Goal" :cases ((< (+ -1 W) (+ 1 N)))
           :in-theory (enable bitn setbitn setbits-rewrite setbits-rewrite-when-j-is-0 bits-bits natp)))
  )

#|
;bad name?
(defthm setbitn-commutativity
  (implies (and (< n n2);(not (equal n n2))
                (case-split (<= 0 n))
                (case-split (<= 0 n2))
                (case-split (< n w))
                (case-split (< n2 w))
                (case-split (integerp w))
                (case-split (integerp n))
                (case-split (integerp n2))
                (case-split (bvecp y 1))
                (case-split (bvecp y2 1))
                (case-split (bvecp x w)) ;drop!
)
           (equal (setbitn (setbitn x w n y) w n2 y2)
                  (setbitn (setbitn x w n2 y2) w n y)
))
  :rule-classes ((:rewrite :loop-stopper ((n n2 s))))
  :hints (("Goal"
           :in-theory (enable setbitn setbits-rewrite setbits-rewrite-when-j-is-0 bits-bits
                              natp
                              )))
  )


(defthm setbitn-commutativity
  (implies (and (< n n2);(not (equal n n2))
                (case-split (<= 0 n))
                (case-split (<= 0 n2))
                (case-split (< n w))
                (case-split (< n2 w))
                (case-split (integerp w))
                (case-split (integerp n))
                (case-split (integerp n2))
                (case-split (bvecp y 1))
                (case-split (bvecp y2 1))
                (case-split (bvecp x w)) ;drop!
)
           (equal (setbitn (setbitn x w n y) w n2 y2)
                  (setbitn (setbitn x w n2 y2) w n y)
))
  :rule-classes ((:rewrite :loop-stopper ((n n2 s))))
  :hints (("Goal"
           :in-theory (set-difference-theories
                       (enable setbitn setbits-rewrite setbits-rewrite-when-j-is-0 
                               bits-bits-1
                               bits-bits-2
                               bits-cat-1
                               bits-cat-2
                               bits-cat-3
                               natp
                              )
                       '(bits-bits bits-cat)
                       ))
          ))

|#