// -*- C++ -*-
#include <klistview.h>
#include <qpixmap.h>
#include <qlayout.h>
#include <kglobalsettings.h>
#include <vector>

#include <apt-front/utils/range.h>

#ifndef EPT_EXTENDABLELIST_H
#define EPT_EXTENDABLELIST_H
namespace adept {

using namespace aptFront;

class ExtendableItem;
class ExtendableList;
class ItemExtender;

class ExtendableList : public KListView {
    Q_OBJECT
public:
    typedef bool(*ItemCompare)( const ExtendableItem *,
                                const ExtendableItem * );
    ExtendableList( QWidget *p = 0, const char *n = 0 );
    virtual ~ExtendableList();
    QPixmap extendedIcon() { return m_extendedIcon; }
    QPixmap baseIcon() { return m_baseIcon; }
    QPixmap unextendableIcon() { return m_unextendableIcon; }
    int extenderOffset( ExtendableItem *i );
    void setExtenderHighlight( bool e ) { m_extenderHighlight = e; }
    bool extenderHighlight() { return m_extenderHighlight; }
public slots:
    void addExtender( ExtendableItem *i );
    void removeExtender( ExtendableItem *i );
    void updateExtender( ExtendableItem *i );
    void delayedUpdateExtenders();
    void updateExtenders();
    void setToggleColumn( int c ) {
        m_toggleColumn = c;
    }
    unsigned toggleColumn() { return m_toggleColumn; }
    virtual void show();
    virtual void clear();
    utils::Range< ExtendableItem * > extenders() {
        return utils::range( m_extenders.begin(), m_extenders.end() ); }
    void openToplevel();
protected slots:
    void processClick( QListViewItem *, const QPoint &, int );
signals:
    void extendersChanged();
protected:
    virtual void resizeEvent( QResizeEvent * );
    virtual void showEvent( QShowEvent * );
    virtual void keyPressEvent( QKeyEvent * );
    std::vector< ExtendableItem * > m_extenders;
    QPixmap m_extendedIcon;
    QPixmap m_baseIcon;
    QPixmap m_unextendableIcon;
    int m_toggleColumn;
    bool m_inDtor:1;
    bool m_extenderUpdateScheduled:1;
    bool m_needSort:1;
    bool m_extenderHighlight:1;
};

class ExtendableItem : public KListViewItem {
public:

    ExtendableItem( ExtendableList *l )
        : KListViewItem( l ), m_extender( 0 ) {
    }

    ExtendableItem( ExtendableList *l, ExtendableItem *prev )
        : KListViewItem( l, prev ), m_extender( 0 ) {
    }

    ExtendableItem( ExtendableItem *p, ExtendableItem *prev )
        : KListViewItem( p, prev ), m_extender( 0 ) {
    }

    ExtendableItem( ExtendableItem *p )
        : KListViewItem( p ), m_extender( 0 ) {
    }

    virtual void setup() {
        KListViewItem::setup();
        updateIcon();
    }
    void toggleExtender();

    void hideExtender() {
        if (extender())
            toggleExtender();
    }

    void showExtender() {
        if (!extender())
            toggleExtender();
    }

    ItemExtender *extender() { return m_extender; }

    static bool s_less( const ExtendableItem *a, const ExtendableItem *b );

    ExtendableList *list();

    virtual void updateIcon();

    virtual void paintBranches( QPainter *, const QColorGroup &, int, int, int );

    virtual ItemExtender *createExtender() = 0;
    virtual bool extendable() const { return false; }
    virtual bool less( const ExtendableItem * ) const = 0;
    virtual int compare( QListViewItem *other, int col, bool ascending ) const;

    virtual ~ExtendableItem();
    virtual void setHeight( int h ) { KListViewItem::setHeight( h ); }
protected:
    ItemExtender *m_extender;
};

class ItemExtender : public QWidget {
    Q_OBJECT
public:
    // ItemExtender( ExtendableItem *item );
    ItemExtender( QWidget *parent, const char *n )
        : QWidget( parent, n ), m_item( 0 )
        {}

    virtual void setItem( ExtendableItem *i ) {
        m_item = i;
    }

    virtual void polish() {
        setupColors();
    }

    ExtendableItem *item() {
        return m_item;
    }

    void resize( int w, int h ) {
        setUpdatesEnabled( false );
        QWidget::resize( w, h );
        setUpdatesEnabled( true );
        QWidget::resize( w, layout()->minimumSize().height() );
    }

    void resize( const QSize &s ) {
        resize( s.width(), s.height() );
    }

public slots:
    void setupColors();
protected:
    virtual void mouseReleaseEvent( QMouseEvent *e ) {
        e->accept();
    } // throw away mouse clicks :-)
    ExtendableItem *m_item;
};

}

#endif
