/** -*- C++ -*-
	@file adept/filterwidgets.h
	@author Peter Rockai <me@mornfall.net>
*/

#include <apt-front/cache/entity/entity.h>
#include <apt-front/cache/entity/package.h>
#include <adept/lister.h>

#ifndef EPT_FILTERWIDGET_H
#define EPT_FILTERWIDGET_H

class KLineEdit;

namespace adept {

class FilterWidget : public QWidget
{
    Q_OBJECT
public:
    FilterWidget( QWidget *parent = 0, const char *n = 0 )
        : QWidget( parent, n ) {}
    virtual ListerPredicate predicate() = 0;
    void connectLister( Lister *l );
protected slots:
    void changedInternal();
    void applyInternal();
    virtual void reset() = 0;
signals:
    void changed( ListerPredicate op );
    void apply( ListerPredicate op );
    void drop( ListerPredicate op );
protected:
    ListerPredicate m_old;
};

}

#endif
