/** -*- C++ -*-
	@file adept/taglist.h
	@author Peter Rockai <me@mornfall.net>
*/

#include <qvbox.h>
#include <qhbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <kiconloader.h>
#include <vector>

#include <apt-front/cache/entity/tag.h>

#ifndef EPT_TAGLIST_H
#define EPT_TAGLIST_H

class QLabel;

namespace adept {

using namespace aptFront;

class TagList;

class TagLabel : public QHBox
{
    Q_OBJECT
public:
    typedef cache::entity::Tag Tag;
    TagLabel( Tag t, TagList *l, QWidget *p = 0, const char *n = 0 );
    Tag tag() { return m_tag; }
protected:
    void mouseReleaseEvent( QMouseEvent *e );
    Tag m_tag;
    QLabel *m_remove;
    QLabel *m_description;
    TagList *m_list;
};

class TagList : public QVBox
{
    Q_OBJECT
public:
    typedef cache::entity::Tag Tag;
    TagList( QWidget *p = 0, const char *n = 0 );
    void setTags( Tag::Set t );
    void addTag( Tag t );
    Tag::Set tags() { return m_tags; }
    void setName( QString n );
public slots:
    void scheduleUpdateList();
    void updateList();
signals:
    void tagsChanged( TagList::Tag::Set );
protected:
    void mouseMoveEvent( QMouseEvent *e );
    void dropEvent( QDropEvent * );
    void dragEnterEvent( QDragEnterEvent * );
    void appendLabel( TagLabel * );
    void clearList();

    bool m_updateScheduled;
    Tag::Set m_tags;
    QLabel *m_name;
    QVBox *m_tagBox;
    QSpacerItem *m_tagSpacer;
    typedef std::vector< TagLabel * > List;
    List m_list;
};

}

#endif
