# Miscellaneous utilities for cross module analysis.
#
# Author::    Yutaka Yanoh <mailto:yanoh@users.sourceforge.net>
# Copyright:: Copyright (C) 2010-2012, OGIS-RI Co.,Ltd.
# License::   GPLv3+: GNU General Public License version 3 or later
#
# Owner::     Yutaka Yanoh <mailto:yanoh@users.sourceforge.net>

#--
#     ___    ____  __    ___   _________
#    /   |  / _  |/ /   / / | / /__  __/           Source Code Static Analyzer
#   / /| | / / / / /   / /  |/ /  / /                   AdLint - Advanced Lint
#  / __  |/ /_/ / /___/ / /|  /  / /
# /_/  |_|_____/_____/_/_/ |_/  /_/   Copyright (C) 2010-2012, OGIS-RI Co.,Ltd.
#
# This file is part of AdLint.
#
# AdLint is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# AdLint is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# AdLint.  If not, see <http://www.gnu.org/licenses/>.
#
#++

module AdLint #:nodoc:
module Ld #:nodoc:

  module DebugUtil
    def dump_function_call_graph(context)
      return unless $DEBUG

      File.open("#{context[:project_name]}.map", "w") do |io|
        mapping = context[:ld_function_mapping]
        call_graph = context[:ld_function_call_graph]
        return unless mapping && call_graph

        io.puts("-- Function Call Graph --")
        mapping.all_functions.each do |callee|
          io.puts("DC of #{callee.signature}")
          call_graph.direct_callers_of(callee).each do |f|
            io.puts(" #{f.signature}")
          end
          io.puts
          io.puts("IC of #{callee.signature}")
          call_graph.indirect_callers_of(callee).each do |f|
            io.puts(" #{f.signature}")
          end
          io.puts
        end
      end
    end
    module_function :dump_function_call_graph

    def dump_variable_reference_graph(context)
      return unless $DEBUG

      File.open("#{context[:project_name]}.map", "a") do |io|
        mapping = context[:ld_variable_mapping]
        reference_graph = context[:ld_variable_reference_graph]
        return unless mapping && reference_graph

        io.puts("-- Variable Reference Graph --")
        mapping.all_variables.each do |variable|
          io.puts("DR of #{variable.name}")
          reference_graph.direct_referrers_of(variable).each do |f|
            io.puts(" #{f.signature}")
          end
          io.puts
          io.puts("IR or #{variable.signature}")
          reference_graph.indirect_referrers_of(variable).each do |f|
            io.puts(" #{f.signature}")
          end
          io.puts
        end
      end
    end
    module_function :dump_variable_reference_graph
  end

end
end
