/*
--------------------------------------------------------------------
File tapeless_scalar.cpp of ADOL-C version 1.10.0   as of July/10/05
--------------------------------------------------------------------
 
   Example: computation of coordinate transform, 
            scalar tapeless forward mode
            described in the manual
 
   Last changes:
   20050627 andrea adapted to current documentation
   20050114 andreas first version 
 
--------------------------------------------------------------------
*/

/****************************************************************************/
/*                                                                 INCLUDES */

#include <iostream>
using namespace std;

#define ADOLC_TAPELESS
#include "../adolc/adouble.h"
typedef adtl::adouble adouble;


int main(int argc, char *argv[]) {
    adouble x[3], y[3];

    for (int i=0; i<3;++i)          // Initialize x_i
        x[i] = i + 1.0;

    cout << endl << "Compute transform from Cartesian to spherical polar coordinates" << endl << endl;

    // derivative of y with respect to x0
    x[0].setADValue(1);

    y[0] = sqrt(x[0]*x[0]+x[1]*x[1]+x[2]*x[2]);
    y[1] = atan(sqrt(x[0]*x[0]+x[1]*x[1])/x[2]);
    y[2] = atan(x[1]/x[0]);

    cout << "cartesian coordinates: " << endl;
    cout << "x[0] = " << x[0].getValue() << "  x[1] = " << x[1].getValue()
    << "  x[2] = " << x[2].getValue() << endl << endl;
    cout << "cpherical polar coordinates: " << endl;
    cout << "y[0] = " << y[0].getValue() << "  y[1] = " << y[1].getValue()
    << "  y[2] = " << y[2].getValue() << endl <<endl;

    // "use" the derivative
    cout << "derivative:" << endl;
    cout << "dy[0]/dx[0] = " << y[0].getADValue() << "  dy[1]/dx[0] = " << y[1].getADValue()
    << "  dy[2]/dx[0] = " << y[2].getADValue() << endl;

    return 0;
}

