/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-06-23 11:06:55 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#ifndef _LANGEVIN_SIMULATOR_
#define _LANGEGIN_SIMULATOR_

#include <math.h>
#include <gsl/gsl_rng.h>
#include <gsl/gsl_randist.h>
#include "AdunKernel/AdUpdating.h"
#include "AdunKernel/AdunKernel.h"

/**
AdLangevinSimulator performs simulation of a system
using langevin dynamics

\todo It should be possible to set a gamma value for each atom in each
subsystem.
\ingroup Cinter
**/

@interface LangevinSimulator: AdSimulator
{
	int seed;
	double gamma;
	double variance;
	gsl_rng* twister;
	id memoryManager;
	NSMutableDictionary* forceMatrices;
}
/**
Value of the friction coefficent used for the langevin dynamics.
*/
- (double) gamma;
/**
Set the value of gamma.
*/
- (void) setGamma: (double) value;
@end

#endif
