/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
/** \file **/
#ifndef ADUN_FORCEFIELD
#define ADUN_FORCEFIELD

#include <stdio.h>
#include <stdlib.h>
#include "AdunKernel/AdunObject.h"
#include "AdunKernel/AdDelegation.h"

/**
**/

/*!
\ingroup Inter
AdForceField is the base class for objects that calculate the acceleration (force)
of the elements of the system. Each AdForceField subclass is essentially the code
representation of a potential energy function and its derivative w.r.t. position
i.e. Enzymix, CHARMM, Amber etc. However it is only concerend with the functional
form not with the value of any parameters this form may require - the parameters are
managed and contained by the AdBondedTopology and NonBondedTopology objects.
In reality most published Force Fields use similar components for the various interactions.
In adun these are written in pure C functions. Thus AdForceField acts as a higher level
manager for the force calculation.
AdForceField adopts the Strategy pattern.
*/

@interface AdForceField: AdObject 
- (void) calculateForces;
- (id) calculatePotential;
- (id) calculatePotentialAndUpdateSystem;
- (id) system;
- (void) setSystem: (id) system;
@end

#endif
