/*
   Project: CAlphaDistance

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-08-01 16:17:23 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#include "CAlphaDistance.h"

@implementation CAlphaDistance

- (void) updateProgressToStep: (int) completedSteps 
		ofTotalSteps: (int) totalSteps 
		withMessage: (NSString*) message
{
	NSMutableDictionary *notificationInfo = [NSMutableDictionary dictionary];

	[notificationInfo setObject: [NSNumber numberWithDouble: totalSteps]
		forKey: @"ULAnalysisPluginTotalSteps"];
	[notificationInfo setObject: message
		forKey: @"ULAnalysisPluginProgressMessage"];
	[notificationInfo setObject: [NSNumber numberWithDouble: completedSteps]
		forKey: @"ULAnalysisPluginCompletedSteps"];
	[[NSNotificationCenter defaultCenter]
		postNotificationName: @"ULAnalysisPluginDidCompleteStepNotification"
		object: self
		userInfo: notificationInfo];
}

- (id) init
{
	if(self == [super init])
	{
		infoDict = [[NSBundle bundleForClass: [self class]]
				infoDictionary];
		[infoDict retain];		
	}

	return self;
}

- (NSDictionary*) pluginOptions: (NSArray*) inputs 
{
	return [NSDictionary dictionary];
}

- (id) processInputs: (NSArray*) inputs userOptions: (NSDictionary*) options 
{	
	int i, j;
	double distance;
	id anObj, structure;
	NSMutableArray* allResidues, *standardHeaders, *threeDHeaders, *standardRow;
	NSEnumerator *chainEnum;
	NSString* string;
	AdDataMatrix* threeDMatrix, *standardMatrix;
	AdDataSet* dataSet;

	structure = [inputs objectAtIndex: 0];
	if(![structure isKindOfClass: [Structure class]])
		[NSException raise: NSInvalidArgumentException
			format: @"CAlphaDistance cannot process %@ objects", 
			NSStringFromClasss([structure class])];

	allResidues  = [NSMutableArray arrayWithCapacity:1];
	chainEnum = [structure allChains];
	
	while((anObj = [chainEnum nextObject]))
		[allResidues addObjectsFromArray: [[anObj allResidues] allObjects]];

	//create the data matrix for holding the standard representation
	standardMatrix = [[AdDataMatrix alloc] initWithRows: 0 columns: [allResidues count]];
	[standardMatrix setName: @"Distance"];
	[standardMatrix autorelease];
	
	standardHeaders = [NSMutableArray array];
	for(i=0; i<[allResidues count]; i++)
	{
		string = [NSString stringWithFormat: @"%@%@ ",
				[[allResidues objectAtIndex: i] name], 
				[[allResidues objectAtIndex: i] number]];
		[standardHeaders addObject: string];
	}	
	[standardMatrix setColumnHeaders: standardHeaders];

	//create the matrix for holding the grid representation
	threeDMatrix = [[AdDataMatrix alloc] initWithRows: 0 columns: 3];
	[threeDMatrix autorelease];
	[threeDMatrix setName: @"Grid"];
	threeDHeaders = [NSArray arrayWithObjects: 
			@"Residue One",
			@"Residue Two", 
			@"Distance", nil];
	[threeDMatrix setColumnHeaders: threeDHeaders];		

	standardRow = [NSMutableArray array];
	for(i=0; i<[allResidues count] - 1; i++)
	{
		for(j=0; j<[allResidues count]; j++)
		{
			distance = [[allResidues objectAtIndex: i] distanceCATo: [allResidues objectAtIndex: j]];
			[standardRow addObject:
				[NSNumber numberWithDouble: distance]];
			[threeDMatrix extendMatrixWithRow: 
				[NSArray arrayWithObjects:
					[NSNumber numberWithInt: i],
					[NSNumber numberWithInt: j],
					[NSNumber numberWithDouble: distance],
					nil]];
		} 
		[standardMatrix extendMatrixWithRow: standardRow];
		[standardRow removeAllObjects];
	}

	//create the data set
	dataSet = [[AdDataSet alloc] initWithName: @"DataSet"
			inputReferences: nil
			dataGeneratorName: @"CAlphaDistance"
			dataGeneratorVersion: [infoDict objectForKey: @"PluginVersion"]];
	[dataSet autorelease];
	[dataSet addDataMatrix: threeDMatrix];
	[dataSet addDataMatrix: standardMatrix];

	[self updateProgressToStep: 90
		ofTotalSteps: 100
		withMessage:  @"Complete"];

	return [NSMutableDictionary dictionaryWithObjectsAndKeys:
			[NSMutableArray arrayWithObject: dataSet], @"ULAnalysisPluginDataSets",
			@"Complte", @"ULAnalysisPluginString", nil];
}

@end
