/*
   Project: UL

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-07-12 15:24:33 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#ifndef _ULFILESYSTEM_DATABASEBACKEND_H_
#define _ULFILESYSTEM_DATABASEBACKEND_H_

#include <Foundation/Foundation.h>
#include "ULFramework/ULIOManager.h"
#include "ULFramework/ULDatabaseIndex.h"
#include "ULFramework/ULDatabaseSimulationIndex.h"

/**
\ingroup mControl
\todo implement reindexAll
*/

@interface ULFileSystemDatabaseBackend : NSObject
{
	ULDatabaseIndex* systemIndex;
	ULDatabaseIndex* optionsIndex;
	ULDatabaseIndex* dataSetIndex;
	ULDatabaseIndex* simulationIndex;
	NSMutableDictionary* databaseIndexes;
	NSString* databaseDir;
	NSString* systemDir;
	NSString* optionsDir;
	NSString* dataSetDir;
	NSString* simulationDir;
	NSTimer* autosaveTimer;
	NSString* databaseName;
	NSString* userName;
	NSMutableArray* contentInformation;
}

/**
Update
*/
- (BOOL) objectInDatabase: (id) object;
- (void) addObject: (id) object
	 	toSchema: (NSString*) schema;
- (void) removeObjectOfClass: (id) className 
		withID: (NSString*) ident
		fromSchema: (NSString*) schema;
- (void) removeObjectsOfClass: (id) className 
		withIDs: (NSArray*) idents
		fromSchema: (NSString*) schema;
- (id) unarchiveObjectWithID: (NSString*) ident 
	ofClass: (id) className
	fromSchema: (NSString*) schema;
- (NSArray*) availableObjectsOfClass: (id) className
		inSchema: (NSString*) schema;
- (NSArray*) contentTypeInformationForSchema: (NSString*) schema;
- (NSDictionary*) metadataForObjectWithID: (NSString*) ident 
			ofClass: (id) type
			inSchema: (NSString*) schema;
- (NSArray*) outputReferencesForObjectWithID: (NSString*) ident
		ofClass: (id) className 
		inSchema: (NSString*) schema;
- (NSArray*) inputReferencesForObjectWithID: (NSString*) ident 
		ofClass: (id) className
		inSchema: (NSString*) schema;
- (void) updateMetadataForObject: (id) object
		inSchema: (NSString*) schema;
- (void) updateOutputReferencesForObject: (id) object;
- (void) removeOutputReferenceToObjectWithID: (NSString*) identOne 
		fromObjectWithID: (NSString*) identTwo
		ofClass: (id) className 
		inSchema: (NSString*) schema;
- (id) createStorageForSimulation: (id) object;
- (NSString*) clientName;
- (NSArray*) schemaInformation;
- (NSString*) simulationDir;
- (NSString*) templateDir;
- (NSString*) systemDir;
- (NSString*) dataSetDir;

/**
Not sure if this is still needed
*/
- (void) reindexAll;
- (void) saveIndexes;
- (void) saveDatabase;
- (void) autosaveIndexes: (id) info;

@end


#endif 

