/*
   Project: UL 

   Copyright (C) 2006 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2006-06-30 13:21:41 +0100 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#ifndef _ULSIMULATION_H_
#define _ULSIMULATION_H_

#include <Foundation/Foundation.h>
#include <AdunKernel/AdunDefinitions.h>
#include <AdunKernel/AdunDynamics.h>
#include <AdunKernel/AdunModelObject.h>
#include "ULFramework/ULMatrix.h"
#include "ULFramework/ULFileSystemSimulationStorage.h"

@class ULDatabaseInterface;

#ifndef _SUBSYSTEMRESULTSINFO_
#define _SUBSYSTEMRESULTSINFO_
typedef struct
{
	int numberOfDynamicsFrames;
	int numberOfStateFrames;
	NSString* subsystemName;
	NSString* stateKey;
	NSString* dynamicsKey;
}
SubsystemResultsInfo;
#endif

/**
\ingroup model
Object representing the output of an AdunKernel simulation process and
associated metadata.
However the location of the output data is volatile and access to it must be
provided to the created ULSimulation instance through a
ULSimulationDataReader subclasss instance using setDataStorage:.

\todo Format of energy archive changed from Kernel 0.9. ULResults has been updated to use the new format
but many of the internal mechanisims it still uses are a direct result of the old format. Need
to optimise ULResults for the new format.
*/

@interface ULSimulation: AdModelObject
{
	BOOL cachedEnergies;
	int numberOfSubsystems;
	double CC;
	NSDictionary* conversionConstants;
	NSMutableData* initialArchive;
	NSData* energyArchive;
	NSMutableArray* trajectoryArchives;
	NSMutableDictionary* subsystemsInfo;
	NSMutableDictionary* subsystemsEnergies;
	SubsystemResultsInfo* subsystemInfoArray;
	id dataStorage;
}

- (id) initWithName: (NSString*) name; 
//temp method
- (void) setEnergyUnit: (NSString*) name;
- (void) printAvailableInfo;
- (NSString*) availableInfo;
- (NSArray*) availableSubsystems;
//energy/state related
- (NSArray*) availableTermsForSubsystem: (NSString*) name;
- (ULMatrix*) energiesForSubsystem: (NSString*) name terms: (NSArray*) terms inFrames: (NSRange*) range step: (int) stepsize;
- (ULMatrix*) energiesForSubsystem: (NSString*) name terms: (NSArray*) terms inFrames: (NSRange*) range;
- (ULMatrix*) energiesForSubsystem: (NSString*) name terms: (NSArray*) terms;
- (ULMatrix*) potentialEnergyForSubsystem: (NSString*) name frames: (NSRange*) range;
- (ULMatrix*) kineticEnergyForSubsystem: (NSString*) name frames: (NSRange*) range;
- (ULMatrix*) totalEnergyForSubsystem: (NSString*) name frames: (NSRange*) range;
- (ULMatrix*) temperatureForSubsystem: (NSString*) name frames: (NSRange*) range;
- (int) initialStateTimeForSubsystem: (NSString*) name;
- (int) lastStateFrameTimeForSubsystem: (NSString*) name;
- (int) timeForStateFrame: (int) frameNumber subsystem: (NSString*) name;
- (int) numberOfStateFramesForSubsystem: (NSString*) name;
- (NSMutableDictionary*) optionsDict;
//configuration related
- (AdMatrix*) coordinatesForFrame: (int) frame subsystem: (NSString*) name;
- (int) timeForCoordinateFrame: (int) frameNumber subsystem: (NSString*) name;
- (int) numberOfCoordinateFramesForSubsystem: (NSString*) name;
- (NSArray*) atomTypesForSubsystem: (NSString*) name;
- (id) dataStorage;
- (void) loadData;
/**
Has no affect after load simulation is called
*/
- (void) setDataStorage: (id) object;
- (NSArray*) atomMassesForSubsystem: (NSString*) name;
@end

#endif // _ULSIMULATION_H_

