/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#ifndef _ADUN_MATRIX_
#define _ADUN_MATRIX_
#include <stdio.h>
#include <stdlib.h>

//! \brief Structure for int matrices 
/**
\ingroup Types
*/

typedef struct
{
	int no_rows;
	int no_columns;
	int** matrix;
}
IntMatrix;


//! \brief Structure for float matrices 
/**
\ingroup Types
*/
typedef struct
{
	int no_rows;
	int no_columns;
	float** matrix;
}
FloatMatrix;

//! \brief Structure for double matrices 
/**
\ingroup Types
*/
typedef struct
{
	int no_rows;
	int no_columns;
	double** matrix;
}
DoubleMatrix;

typedef double AdMatrixSize;

//typedefs for AdMatrix - we make AdMatrix refer to the DoubleMatrix type

typedef DoubleMatrix AdMatrix;

//prototypes
/**
\defgroup matrix Matrix
\ingroup Functions
@{
**/

inline void AdSetDoubleMatrixWithValue(DoubleMatrix *, double);
inline void AdSetFloatMatrixWithValue(FloatMatrix *,  float);
inline void AdSetIntMatrixWithValue(IntMatrix *, int);

inline IntMatrix* AdIntMatrixFromRowSection(IntMatrix *, int , int);
inline FloatMatrix* AdFloatMatrixFromRowSection(FloatMatrix *, int , int);
inline DoubleMatrix* AdDoubleMatrixFromRowSection(DoubleMatrix *, int , int);

inline IntMatrix* AdIntMatrixFromRowSelection(IntMatrix *, int* , int);
inline FloatMatrix* AdFloatMatrixFromRowSelection(FloatMatrix *, int* , int);
inline DoubleMatrix* AdDoubleMatrixFromRowSelection(DoubleMatrix *, int* , int);

inline IntMatrix* AdIntMatrixFromColumnSection(IntMatrix *, int , int);
inline FloatMatrix* AdFloatMatrixFromColumnSection(FloatMatrix *, int , int);
inline DoubleMatrix* AdDoubleMatrixFromColumnSection(DoubleMatrix *, int , int);

inline IntMatrix* AdIntMatrixFromColumnSelection(IntMatrix *, int* , int);
inline FloatMatrix* AdFloatMatrixFromColumnSelection(FloatMatrix *, int* , int);
inline DoubleMatrix* AdDoubleMatrixFromColumnSelection(DoubleMatrix *, int* , int);

inline void AdFreeDoubleMatrix(DoubleMatrix*);
inline void AdFreeIntMatrix(IntMatrix*);
inline void AdFreeFloatMatrix(FloatMatrix*);

inline IntMatrix* AdAllocateIntMatrix(int, int);
inline FloatMatrix* AdAllocateFloatMatrix(int, int);
inline DoubleMatrix* AdAllocateDoubleMatrix(int, int);

/**
AdMatrix copy function.
*/
inline void AdCopyAdMatrixToAdMatrix(DoubleMatrix*, DoubleMatrix*);
#endif
