#! /usr/bin/env python
'''InstallPlugin - Python script for installing Adun plugins

Usage: InstallPlugin.py -t [type]

Arguments:
    -t  Plugin type. Must be one of the following -
        Controller, Analysis, Configurations

Note: Script must be run in the plugin source directory.'''

import os, sys, getopt, shutil

def GetPluginName():

    '''Gets the plugin name by reading Info-gnustep.plist

    Calls sys.exit() if Info-gnustep.plist doesnt exist'''

    try:
        f = open("Resources/Info-gnustep.plist")
    except IOError:
        print "Unable to read Info-gnustep.plist"
        print "Cannot determine plugin name"
        sys.exit(1)

    plist = f.read()

    #Search for NSExecutable
    index = plist.find("NSExecutable")
    if index == -1:
        print "Error in plugin description" 
        print "Info-gnustep.plist is missing NSExectuable entry"
        sys.exit(1)

    plist = plist[index:]
    end = plist.find("\n")
    plist = plist[:end]
    elements = plist.strip("\n").strip().strip(";").split()
    name = elements[2]
    #We have to get rid of the "" around the name
    name = name.strip('"')
    return name

def CheckBuild(name):

    '''Returns true if a build is needed. False otherwise'''

    x = os.listdir(".")
    return not x.count(name)

if __name__ == "__main__":

    try:
        opt = getopt.getopt(sys.argv[1:], "t:")
        opt = dict(opt[0])
    except getopt.GetoptError, data:
        print "Error - %s" % data
        print __doc__
        sys.exit(1)

    allowedType = ["Controllers", "Analysis", "Configurations"]

    #Parse options
    if opt.has_key("-t"):
        pluginType = opt["-t"]
        if allowedType.count(pluginType) == 0:
            print "Type %s is not known" % pluginType
            print __doc__
            sys.exit(1)
    else:
        print "Must define plugin type"
        print __doc__
        sys.exit(1)

    name = GetPluginName()
    print "Plugin is %s" % name
    build = CheckBuild(name)

    #If build was requested execute make
    if build:
        print "Build required ..."
        os.system("make")

    #Check installation dir exists
    pluginDir = os.path.expandvars("$HOME/adun/Plugins/" + pluginType)
    if not os.path.exists(pluginDir):
        print 'Required plugin directory %s does not exist' % pluginDir
        print __doc__
        sys.exit(1)

    destinationDir = os.path.join(pluginDir, name)
    #Check if a previous plugin version was installed
    if os.path.exists(destinationDir):
        print "Detected previous copy of %s - Removing" % name
        try:
            shutil.rmtree(destinationDir)
        except OSError, data:
            print "Remove failed"
            print "%s - %s" % (data.strerror, data.filename)
            sys.exit(1)

    #Install the plugin            
    print "Installing %s into %s" % (name, pluginDir)
    shutil.copytree(name, destinationDir, symlinks=True)
    try:
        shutil.rmtree(name)
    except OSError, data:
        print "Remove failed"
        print "%s - %s" % (data.strerror, data.filename)
    
    

        

    

  
